/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.events;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.test.framework.events.SysLog;
import org.keycloak.test.framework.events.SysLogListener;

public class SysLogServer {
    private static final Logger LOGGER = Logger.getLogger(SysLogServer.class);
    private static final int MAX_THREADS = 5;
    private ServerSocket serverSocket;
    private final List<Thread> threads = Collections.synchronizedList(new LinkedList());
    private final Set<SysLogListener> listeners = new HashSet<SysLogListener>();
    private boolean running = true;

    public void start() throws IOException {
        this.serverSocket = new ServerSocket(0);
        this.startThread();
    }

    public void stop() throws InterruptedException, IOException {
        LOGGER.tracev("Shutdown, threads={0}", (Object)this.threads.size());
        this.running = false;
        this.serverSocket.close();
        for (Thread t : this.threads) {
            t.join();
        }
    }

    public void addListener(SysLogListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SysLogListener listener) {
        this.listeners.remove(listener);
    }

    public String getEndpoint() {
        return "localhost:" + this.serverSocket.getLocalPort();
    }

    protected void startThread() {
        if (this.running && this.threads.size() < 5) {
            Thread thread = new Thread(new BasicSocketHandler());
            thread.start();
            this.threads.add(thread);
            LOGGER.tracev("Started new thread, running threads={0}", (Object)this.threads.size());
        }
    }

    private class BasicSocketHandler
    implements Runnable {
        private BasicSocketHandler() {
        }

        @Override
        public void run() {
            while (SysLogServer.this.running) {
                try {
                    Socket socket = SysLogServer.this.serverSocket.accept();
                    LOGGER.trace((Object)"Socket accepted");
                    SysLogServer.this.startThread();
                    BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String l = br.readLine();
                    while (l != null) {
                        try {
                            SysLog sysLog = SysLog.parse(l);
                            SysLogServer.this.listeners.forEach(listener -> listener.onLog(sysLog));
                        }
                        catch (Throwable t) {
                            LOGGER.tracev("Failed to parse message={0}", (Object)l);
                        }
                        l = br.readLine();
                    }
                    socket.close();
                    LOGGER.trace((Object)"Socket closed");
                }
                catch (Throwable t) {
                    if (SysLogServer.this.serverSocket.isClosed()) continue;
                    LOGGER.trace((Object)t.getMessage(), t);
                }
            }
        }
    }
}

