/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.database;

import java.util.HashMap;
import org.keycloak.test.framework.database.AbstractDatabaseSupplier;
import org.keycloak.test.framework.database.DatabaseConfig;
import org.keycloak.test.framework.database.TestDatabase;

public class OracleDatabaseSupplier
extends AbstractDatabaseSupplier {
    public static final String VENDOR = "oracle";
    private static final String CONTAINER_IMAGE = "docker.io/miquelsi/oracle-19c:19.3";

    @Override
    TestDatabase getTestDatabase() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORACLE_SID", "keycloak");
        env.put("ORACLE_PWD", "sa");
        DatabaseConfig databaseConfig = new DatabaseConfig().vendor(VENDOR).username("keycloak").password("Password1!").postStartCommand("(echo 'alter session set \"_ORACLE_SCRIPT\"=true;' && echo 'CREATE USER keycloak IDENTIFIED BY \"Password1!\";' && echo 'GRANT CONNECT,RESOURCE,DBA,GRANT ANY PRIVILEGE,UNLIMITED TABLESPACE TO keycloak;') | sqlplus -L SYS/" + (String)env.get("ORACLE_PWD") + "@localhost/" + (String)env.get("ORACLE_SID") + " AS SYSDBA").containerImage(CONTAINER_IMAGE).env(env);
        return new TestDatabase(databaseConfig);
    }

    @Override
    public String getAlias() {
        return VENDOR;
    }
}

