/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.page;

import org.junit.jupiter.api.Assertions;
import org.keycloak.test.framework.page.AbstractPage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class WelcomePage
extends AbstractPage {
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="password-confirmation")
    private WebElement passwordConfirmationInput;
    @FindBy(css="[type=submit]")
    private WebElement submitButton;
    @FindBy(css=".pf-v5-c-alert")
    private WebElement pageAlert;

    public WelcomePage(WebDriver driver) {
        super(driver);
    }

    public void navigateTo() {
        this.driver.get("http://localhost:8080");
    }

    public void fillRegistration(String username, String password) {
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.passwordConfirmationInput.sendKeys(new CharSequence[]{password});
    }

    public void submit() {
        this.submitButton.click();
    }

    public void assertUserCreated() {
        Assertions.assertTrue((boolean)this.pageAlert.getText().contains("User created"));
    }
}

