/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.keycloak.test.framework.injection.InstanceContext;

public class SupplierHelpers {
    public static <T> T getInstance(Class<T> clazz) {
        try {
            Constructor<T> declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getAnnotationField(Annotation annotation, String name, T defaultValue) {
        T value = SupplierHelpers.getAnnotationField(annotation, name);
        return value != null ? value : defaultValue;
    }

    public static <T> T getAnnotationField(Annotation annotation, String name) {
        if (annotation != null) {
            for (Method m : annotation.annotationType().getMethods()) {
                if (!m.getName().equals(name)) continue;
                try {
                    return (T)m.invoke((Object)annotation, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public static String createName(InstanceContext<?, ?> instanceContext) {
        return instanceContext.getRef() != null ? instanceContext.getRef() : "default";
    }
}

