/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.injection;

import java.lang.annotation.Annotation;
import org.keycloak.test.framework.injection.InstanceContext;
import org.keycloak.test.framework.injection.LifeCycle;
import org.keycloak.test.framework.injection.RequestedInstance;
import org.keycloak.test.framework.injection.StringUtil;
import org.keycloak.test.framework.injection.SupplierHelpers;

public interface Supplier<T, S extends Annotation> {
    public Class<S> getAnnotationClass();

    public Class<T> getValueType();

    public T getValue(InstanceContext<T, S> var1);

    default public String getRef(S annotation) {
        return StringUtil.convertEmptyToNull((String)SupplierHelpers.getAnnotationField(annotation, "ref"));
    }

    default public LifeCycle getLifeCycle(S annotation) {
        return SupplierHelpers.getAnnotationField(annotation, "lifecycle", this.getDefaultLifecycle());
    }

    default public LifeCycle getDefaultLifecycle() {
        return LifeCycle.CLASS;
    }

    public boolean compatible(InstanceContext<T, S> var1, RequestedInstance<T, S> var2);

    default public void close(InstanceContext<T, S> instanceContext) {
    }

    default public String getAlias() {
        return this.getClass().getSimpleName();
    }

    default public void onBeforeEach(InstanceContext<T, S> instanceContext) {
    }
}

