/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.injection;

import java.lang.annotation.Annotation;
import org.keycloak.test.framework.injection.LifeCycle;
import org.keycloak.test.framework.injection.StringUtil;
import org.keycloak.test.framework.injection.Supplier;

public class RequestedInstance<T, A extends Annotation> {
    private final Supplier<T, A> supplier;
    private final A annotation;
    private final Class<? extends T> valueType;
    private final LifeCycle lifeCycle;
    private final String ref;

    public RequestedInstance(Supplier<T, A> supplier, A annotation, Class<? extends T> valueType) {
        this.supplier = supplier;
        this.annotation = annotation;
        this.valueType = valueType;
        this.lifeCycle = supplier.getLifeCycle(annotation);
        this.ref = StringUtil.convertEmptyToNull(supplier.getRef(annotation));
    }

    public Supplier<T, A> getSupplier() {
        return this.supplier;
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public Class<? extends T> getValueType() {
        return this.valueType;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public String getRef() {
        return this.ref;
    }
}

