/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.injection;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.test.framework.injection.LifeCycle;
import org.keycloak.test.framework.injection.Registry;
import org.keycloak.test.framework.injection.StringUtil;
import org.keycloak.test.framework.injection.Supplier;

public class InstanceContext<T, A extends Annotation> {
    private final Registry registry;
    private final Supplier<T, A> supplier;
    private final A annotation;
    private final Set<InstanceContext<T, A>> dependencies = new HashSet<InstanceContext<T, A>>();
    private T value;
    private Class<? extends T> requestedValueType;
    private LifeCycle lifeCycle;
    private final String ref;
    private final Map<String, Object> notes = new HashMap<String, Object>();

    public InstanceContext(Registry registry, Supplier<T, A> supplier, A annotation, Class<? extends T> requestedValueType) {
        this.registry = registry;
        this.supplier = supplier;
        this.annotation = annotation;
        this.requestedValueType = requestedValueType;
        this.lifeCycle = supplier.getLifeCycle(annotation);
        this.ref = StringUtil.convertEmptyToNull(supplier.getRef(annotation));
    }

    public <D> D getDependency(Class<D> typeClazz) {
        return this.getDependency(typeClazz, null);
    }

    public <D> D getDependency(Class<D> typeClazz, String ref) {
        return this.registry.getDependency(typeClazz, ref, this);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    void setValue(T value) {
        this.value = value;
    }

    public Supplier<T, A> getSupplier() {
        return this.supplier;
    }

    public T getValue() {
        return this.value;
    }

    public Class<? extends T> getRequestedValueType() {
        return this.requestedValueType;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public String getRef() {
        return this.ref;
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public Set<InstanceContext<T, A>> getDependencies() {
        return this.dependencies;
    }

    public void registerDependency(InstanceContext<T, A> instanceContext) {
        this.dependencies.add(instanceContext);
    }

    public void addNote(String key, Object value) {
        this.notes.put(key, value);
    }

    public <N> N getNote(String key, Class<N> type) {
        return (N)this.notes.get(key);
    }
}

