/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.authentication;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class KeycloakCookieBasedRedirect {
    private static final String REDIRECT_COOKIE = "KC_REDIRECT";

    private KeycloakCookieBasedRedirect() {
    }

    public static String getRedirectUrlFromCookie(HttpServletRequest request) {
        if (request.getCookies() == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!REDIRECT_COOKIE.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static Cookie createCookieFromRedirectUrl(String url) {
        Cookie cookie = new Cookie(REDIRECT_COOKIE, url == null ? "" : url);
        cookie.setHttpOnly(true);
        cookie.setPath("/");
        if (url == null) {
            cookie.setMaxAge(0);
        }
        return cookie;
    }
}

