/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.facade;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.adapters.spi.HttpFacade;
import org.springframework.util.Assert;

class WrappedHttpServletRequest
implements HttpFacade.Request {
    private final HttpServletRequest request;

    public WrappedHttpServletRequest(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"HttpServletRequest required");
        this.request = request;
    }

    public String getFirstParam(String param) {
        return this.request.getParameter(param);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getURI() {
        StringBuffer buf = this.request.getRequestURL();
        if (this.request.getQueryString() != null) {
            buf.append('?').append(this.request.getQueryString());
        }
        return buf.toString();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getQueryParamValue(String param) {
        return this.request.getParameter(param);
    }

    public HttpFacade.Cookie getCookie(String cookieName) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : this.request.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }
        return null;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public List<String> getHeaders(String name) {
        Enumeration values = this.request.getHeaders(name);
        ArrayList array = new ArrayList();
        while (values.hasMoreElements()) {
            array.add(values.nextElement());
        }
        return Collections.unmodifiableList(array);
    }

    public InputStream getInputStream() {
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get request input stream", e);
        }
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }
}

