/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;

public class KeycloakAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    public static final String DEFAULT_LOGIN_URI = "/sso/login";
    private static final Logger log = LoggerFactory.getLogger(KeycloakAuthenticationEntryPoint.class);
    private String loginUri = "/sso/login";

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String contextAwareLoginUri = request.getContextPath() + this.loginUri;
        log.debug("Redirecting to login URI {}", (Object)contextAwareLoginUri);
        response.sendRedirect(contextAwareLoginUri);
    }

    public void setLoginUri(String loginUri) {
        Assert.notNull((Object)loginUri, (String)"loginUri cannot be null");
        this.loginUri = loginUri;
    }
}

