/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.facade;

import javax.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.springsecurity.facade.WrappedHttpServletRequest;
import org.keycloak.adapters.springsecurity.facade.WrappedHttpServletResponse;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class SimpleHttpFacade
implements HttpFacade {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public SimpleHttpFacade(HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)request, (String)"HttpServletRequest required");
        Assert.notNull((Object)response, (String)"HttpServletResponse required");
        this.request = request;
        this.response = response;
    }

    public KeycloakSecurityContext getSecurityContext() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && context.getAuthentication() != null) {
            return (KeycloakSecurityContext)context.getAuthentication().getDetails();
        }
        return null;
    }

    public HttpFacade.Request getRequest() {
        return new WrappedHttpServletRequest(this.request);
    }

    public HttpFacade.Response getResponse() {
        return new WrappedHttpServletResponse(this.response);
    }

    public X509Certificate[] getCertificateChain() {
        return new X509Certificate[0];
    }
}

