/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.filter;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.springsecurity.AdapterDeploymentContextBean;
import org.keycloak.adapters.springsecurity.authentication.SpringSecurityRequestAuthenticator;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.keycloak.adapters.springsecurity.token.SpringSecurityTokenStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class KeycloakAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter
implements ApplicationContextAware {
    public static final RequestMatcher DEFAULT_REQUEST_MATCHER = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/sso/login"), new RequestHeaderRequestMatcher("Authorization")});
    private static final Logger log = LoggerFactory.getLogger(KeycloakAuthenticationProcessingFilter.class);
    private ApplicationContext applicationContext;
    private AdapterDeploymentContextBean adapterDeploymentContextBean;
    private AuthenticationManager authenticationManager;

    public KeycloakAuthenticationProcessingFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_REQUEST_MATCHER);
    }

    public KeycloakAuthenticationProcessingFilter(AuthenticationManager authenticationManager, RequestMatcher requiresAuthenticationRequestMatcher) {
        super(requiresAuthenticationRequestMatcher);
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        super.setAuthenticationManager(authenticationManager);
    }

    public void afterPropertiesSet() {
        this.adapterDeploymentContextBean = (AdapterDeploymentContextBean)this.applicationContext.getBean(AdapterDeploymentContextBean.class);
        super.afterPropertiesSet();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        log.debug("Attempting Keycloak authentication");
        KeycloakDeployment deployment = this.adapterDeploymentContextBean.getDeployment();
        SimpleHttpFacade facade = new SimpleHttpFacade(request, response);
        SpringSecurityTokenStore tokenStore = new SpringSecurityTokenStore(deployment, request);
        SpringSecurityRequestAuthenticator authenticator = new SpringSecurityRequestAuthenticator(facade, request, deployment, tokenStore, -1);
        AuthOutcome result = authenticator.authenticate();
        AuthChallenge challenge = authenticator.getChallenge();
        log.debug("Auth outcome: {}", (Object)result);
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
        }
        if (AuthOutcome.AUTHENTICATED.equals((Object)result)) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Assert.notNull((Object)authentication, (String)"Authentication SecurityContextHolder was null");
            return this.authenticationManager.authenticate(authentication);
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

