/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.facade;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.HttpFacade;

class WrappedHttpServletResponse
implements HttpFacade.Response {
    private final HttpServletResponse response;

    public WrappedHttpServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void resetCookie(String name, String path) {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0);
        if (path != null) {
            cookie.setPath(path);
        }
        this.response.addCookie(cookie);
    }

    public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
        Cookie cookie = new Cookie(name, value);
        if (path != null) {
            cookie.setPath(path);
        }
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secure);
        cookie.setHttpOnly(httpOnly);
        this.response.addCookie(cookie);
    }

    public void setStatus(int status) {
        this.response.setStatus(status);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public OutputStream getOutputStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to return response output stream", e);
        }
    }

    public void sendError(int code, String message) {
        try {
            this.response.sendError(code, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to set HTTP status", e);
        }
    }

    public void end() {
    }
}

