/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.twitter;

import java.net.URI;
import org.keycloak.social.AuthCallback;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.SocialAccessDeniedException;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.RequestToken;

public class TwitterProvider
implements SocialProvider {
    public String getId() {
        return "twitter";
    }

    public AuthRequest getAuthUrl(SocialProviderConfig config, String state) throws SocialProviderException {
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            twitter.setOAuthConsumer(config.getKey(), config.getSecret());
            URI uri = new URI(config.getCallbackUrl() + "?state=" + state);
            RequestToken requestToken = twitter.getOAuthRequestToken(uri.toString());
            return AuthRequest.create((String)requestToken.getAuthenticationURL()).setAttribute("token", requestToken.getToken()).setAttribute("tokenSecret", requestToken.getTokenSecret()).build();
        }
        catch (Exception e) {
            throw new SocialProviderException((Throwable)e);
        }
    }

    public String getName() {
        return "Twitter";
    }

    public SocialUser processCallback(SocialProviderConfig config, AuthCallback callback) throws SocialProviderException {
        if (callback.getQueryParam("denied") != null) {
            throw new SocialAccessDeniedException();
        }
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            twitter.setOAuthConsumer(config.getKey(), config.getSecret());
            String token = callback.getQueryParam("oauth_token");
            String verifier = callback.getQueryParam("oauth_verifier");
            RequestToken requestToken = new RequestToken(callback.getAttribute("token"), callback.getAttribute("tokenSecret"));
            twitter.getOAuthAccessToken(requestToken, verifier);
            User twitterUser = twitter.verifyCredentials();
            SocialUser user = new SocialUser(Long.toString(twitterUser.getId()), twitterUser.getScreenName());
            user.setName(twitterUser.getName());
            return user;
        }
        catch (Exception e) {
            throw new SocialProviderException((Throwable)e);
        }
    }
}

