/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class AuthRequest {
    private URI authUri;
    private Map<String, String> attributes;

    public static AuthRequestBuilder create(String url) {
        AuthRequestBuilder req = new AuthRequestBuilder();
        req.b = new StringBuilder();
        req.b.append(url);
        return req;
    }

    private AuthRequest(URI authUri, Map<String, String> attributes) {
        this.authUri = authUri;
        this.attributes = attributes;
    }

    public URI getAuthUri() {
        return this.authUri;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public static class AuthRequestBuilder {
        private StringBuilder b;
        private char sep = (char)63;
        private Map<String, String> attributes;
        private String id;

        private AuthRequestBuilder() {
        }

        public AuthRequestBuilder setQueryParam(String name, String value) {
            try {
                if (this.sep == '?') {
                    this.b.append(this.sep);
                    this.sep = (char)38;
                } else {
                    this.b.append(this.sep);
                }
                this.b.append(URLEncoder.encode(name, "UTF-8"));
                this.b.append("=");
                this.b.append(URLEncoder.encode(value, "UTF-8"));
                return this;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        public AuthRequestBuilder setAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(name, value);
            return this;
        }

        public AuthRequest build() {
            try {
                return new AuthRequest(new URI(this.b.toString()), this.attributes);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

