/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.security.cert.X509Certificate;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.ServerCookie;
import org.keycloak.common.util.UriUtils;

public class ServletHttpFacade
implements HttpFacade {
    protected final RequestFacade requestFacade = new RequestFacade();
    protected final ResponseFacade responseFacade = new ResponseFacade();
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected MultivaluedHashMap<String, String> queryParameters;

    public ServletHttpFacade(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public boolean isEnded() {
        return this.responseFacade.isEnded();
    }

    public HttpFacade.Request getRequest() {
        return this.requestFacade;
    }

    public HttpFacade.Response getResponse() {
        return this.responseFacade;
    }

    public X509Certificate[] getCertificateChain() {
        throw new IllegalStateException("Not supported yet");
    }

    protected class ResponseFacade
    implements HttpFacade.Response {
        protected boolean ended;

        protected ResponseFacade() {
        }

        public void setStatus(int status) {
            ServletHttpFacade.this.response.setStatus(status);
        }

        public void addHeader(String name, String value) {
            ServletHttpFacade.this.response.addHeader(name, value);
        }

        public void setHeader(String name, String value) {
            ServletHttpFacade.this.response.setHeader(name, value);
        }

        public void resetCookie(String name, String path) {
            this.setCookie(name, "", path, null, 0, false, false);
        }

        public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            StringBuffer cookieBuf = new StringBuffer();
            ServerCookie.appendCookieValue((StringBuffer)cookieBuf, (int)1, (String)name, (String)value, (String)path, (String)domain, null, (int)maxAge, (boolean)secure, (boolean)httpOnly);
            String cookie = cookieBuf.toString();
            ServletHttpFacade.this.response.addHeader("Set-Cookie", cookie);
        }

        public OutputStream getOutputStream() {
            try {
                return ServletHttpFacade.this.response.getOutputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void sendError(int code) {
            try {
                ServletHttpFacade.this.response.sendError(code);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void sendError(int code, String message) {
            try {
                ServletHttpFacade.this.response.sendError(code, message);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void end() {
            this.ended = true;
        }

        public boolean isEnded() {
            return this.ended;
        }
    }

    protected class RequestFacade
    implements HttpFacade.Request {
        protected RequestFacade() {
        }

        public String getMethod() {
            return ServletHttpFacade.this.request.getMethod();
        }

        public String getURI() {
            StringBuffer buf = ServletHttpFacade.this.request.getRequestURL();
            if (ServletHttpFacade.this.request.getQueryString() != null) {
                buf.append('?').append(ServletHttpFacade.this.request.getQueryString());
            }
            return buf.toString();
        }

        public boolean isSecure() {
            return ServletHttpFacade.this.request.isSecure();
        }

        public String getFirstParam(String param) {
            return ServletHttpFacade.this.request.getParameter(param);
        }

        public String getQueryParamValue(String param) {
            if (ServletHttpFacade.this.queryParameters == null) {
                ServletHttpFacade.this.queryParameters = UriUtils.decodeQueryString((String)ServletHttpFacade.this.request.getQueryString());
            }
            return (String)ServletHttpFacade.this.queryParameters.getFirst((Object)param);
        }

        public MultivaluedHashMap<String, String> getQueryParameters() {
            if (ServletHttpFacade.this.queryParameters == null) {
                ServletHttpFacade.this.queryParameters = UriUtils.decodeQueryString((String)ServletHttpFacade.this.request.getQueryString());
            }
            return ServletHttpFacade.this.queryParameters;
        }

        public HttpFacade.Cookie getCookie(String cookieName) {
            if (ServletHttpFacade.this.request.getCookies() == null) {
                return null;
            }
            Cookie cookie = null;
            for (Cookie c : ServletHttpFacade.this.request.getCookies()) {
                if (!c.getName().equals(cookieName)) continue;
                cookie = c;
                break;
            }
            if (cookie == null) {
                return null;
            }
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }

        public String getHeader(String name) {
            return ServletHttpFacade.this.request.getHeader(name);
        }

        public List<String> getHeaders(String name) {
            Enumeration values = ServletHttpFacade.this.request.getHeaders(name);
            LinkedList<String> list = new LinkedList<String>();
            while (values.hasMoreElements()) {
                list.add((String)values.nextElement());
            }
            return list;
        }

        public InputStream getInputStream() {
            try {
                return ServletHttpFacade.this.request.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getRemoteAddr() {
            return ServletHttpFacade.this.request.getRemoteAddr();
        }

        public void setError(AuthenticationError error) {
            ServletHttpFacade.this.request.setAttribute(AuthenticationError.class.getName(), (Object)error);
        }

        public void setError(LogoutError error) {
            ServletHttpFacade.this.request.setAttribute(LogoutError.class.getName(), (Object)error);
        }
    }
}

