/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import jakarta.ws.rs.ForbiddenException;
import java.util.List;
import java.util.Map;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.identity.UserModelIdentity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.admin.fgap.FineGrainedAdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.MgmtPermissionsV2;
import org.keycloak.services.resources.admin.fgap.ModelRecord;
import org.keycloak.services.resources.admin.fgap.UserPermissions;

class UserPermissionsV2
extends UserPermissions {
    private final FineGrainedAdminPermissionEvaluator eval;

    UserPermissionsV2(KeycloakSession session, AuthorizationProvider authz, MgmtPermissionsV2 root) {
        super(session, authz, root);
        this.eval = new FineGrainedAdminPermissionEvaluator(session, root, this.resourceStore, this.policyStore);
    }

    @Override
    public boolean canQuery() {
        return this.root.hasOneAdminRole("query-users") || this.canView();
    }

    @Override
    public void requireQuery() {
        if (!this.canQuery()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(UserModel user) {
        if (this.root.hasOneAdminRole("manage-users", "view-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.UserModelRecord(user), null, "view");
    }

    @Override
    public boolean canView() {
        if (this.root.hasOneAdminRole("manage-users", "view-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.UserModelRecord(null), null, "view");
    }

    @Override
    public void requireView(UserModel user) {
        if (!this.canView(user)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireView() {
        if (!this.canView()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManage(UserModel user) {
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.UserModelRecord(user), null, "manage");
    }

    @Override
    public boolean canManage() {
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.UserModelRecord(null), null, "manage");
    }

    @Override
    public void requireManage(UserModel user) {
        if (!this.canManage(user)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireManage() {
        if (!this.canManage()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canImpersonate(UserModel user, ClientModel requester) {
        if (this.root.hasOneAdminRole("impersonation")) {
            return true;
        }
        DefaultEvaluationContext context = requester == null ? null : new DefaultEvaluationContext((Identity)new UserModelIdentity(this.root.realm, user), Map.of("kc.client.id", List.of(requester.getClientId())), this.session);
        return this.eval.hasPermission(new ModelRecord.UserModelRecord(user), context, "impersonate");
    }

    @Override
    public boolean canMapRoles(UserModel user) {
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.UserModelRecord(user), null, "map-roles");
    }

    @Override
    public boolean canManageGroupMembership(UserModel user) {
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.UserModelRecord(user), null, "manage-group-membership");
    }

    @Override
    public boolean canClientImpersonate(ClientModel client, UserModel user) {
        return this.canImpersonate(user, client);
    }

    @Override
    public boolean isImpersonatable(UserModel user, ClientModel requester) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public boolean isImpersonatable(UserModel user) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public boolean isPermissionsEnabled() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public void setPermissionsEnabled(boolean enable) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Map<String, String> getPermissions() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Resource resource() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy managePermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy manageGroupMembershipPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolesPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy adminImpersonatingPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy userImpersonatedPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }
}

