/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.KeycloakSession;

public class OAuth2IdentityProvider
extends AbstractOAuth2IdentityProvider<OAuth2IdentityProviderConfig> {
    public OAuth2IdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
    }

    @Override
    protected String getDefaultScopes() {
        return "";
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        BrokeredIdentityContext identity = new BrokeredIdentityContext(this.getConfig());
        if (accessToken != null) {
            String familyName;
            JsonNode userInfo = this.fetchUserProfile(accessToken);
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(identity, userInfo, this.getConfig().getAlias());
            String id = this.getJsonProperty(userInfo, this.getConfig().getUserIDClaim());
            identity.setId(id);
            String givenName = this.getJsonProperty(userInfo, this.getConfig().getGivenNameClaim());
            if (givenName != null) {
                identity.setFirstName(givenName);
            }
            if ((familyName = this.getJsonProperty(userInfo, this.getConfig().getFamilyNameClaim())) != null) {
                identity.setLastName(familyName);
            }
            if (givenName == null && familyName == null) {
                String name = this.getJsonProperty(userInfo, this.getConfig().getFullNameClaim());
                identity.setName(name);
            }
            String email = this.getJsonProperty(userInfo, this.getConfig().getEmailClaim());
            identity.setEmail(email);
            identity.setBrokerUserId(this.getConfig().getAlias() + "." + id);
            String preferredUsername = this.getJsonProperty(userInfo, this.getConfig().getUserNameClaim());
            if (preferredUsername == null) {
                preferredUsername = email;
            }
            if (preferredUsername == null) {
                preferredUsername = id;
            }
            identity.setUsername(preferredUsername);
        }
        return identity;
    }

    private JsonNode fetchUserProfile(String accessToken) {
        JsonNode jsonNode;
        block12: {
            String userInfoUrl = this.getConfig().getUserInfoUrl();
            SimpleHttp.Response response = this.executeRequest(userInfoUrl, SimpleHttp.doGet((String)userInfoUrl, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken).header("Accept", "application/json"));
            try {
                MediaType contentMediaType;
                String contentType = response.getFirstHeader("Content-Type");
                try {
                    contentMediaType = MediaType.valueOf((String)contentType);
                }
                catch (IllegalArgumentException ex) {
                    contentMediaType = null;
                }
                if (contentMediaType == null || contentMediaType.isWildcardSubtype() || contentMediaType.isWildcardType()) {
                    throw new RuntimeException("Unsupported content-type [" + contentType + "] in response from [" + userInfoUrl + "].");
                }
                if (!MediaType.APPLICATION_JSON_TYPE.isCompatible(contentMediaType)) {
                    throw new RuntimeException("Unsupported content-type [" + contentType + "] in response from [" + userInfoUrl + "].");
                }
                jsonNode = response.asJson();
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IdentityBrokerException("Error while fetching user profile", (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    private SimpleHttp.Response executeRequest(String url, SimpleHttp request) throws IOException {
        SimpleHttp.Response response = request.asResponse();
        int status = response.getStatus();
        if (Response.Status.fromStatusCode((int)status).getFamily() != Response.Status.Family.SUCCESSFUL) {
            logger.warnf("User profile endpoint (%s) returned an error (%d): %s", (Object)url, (Object)status, (Object)response.asString());
            throw new RuntimeException("Unexpected response from user profile endpoint");
        }
        return response;
    }
}

