/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.authentication.authenticators.browser;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.authenticators.browser.IdentityProviderAuthenticator;
import org.keycloak.authentication.authenticators.browser.WebAuthnConditionalUIAuthenticator;
import org.keycloak.email.freemarker.beans.ProfileBean;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.model.AuthenticationContextBean;
import org.keycloak.forms.login.freemarker.model.IdentityProviderBean;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareAuthenticationContextBean;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareIdentityProviderBean;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareRealmBean;
import org.keycloak.organization.protocol.mappers.oidc.OrganizationScope;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.StringUtil;

public class OrganizationAuthenticator
extends IdentityProviderAuthenticator {
    private static final String LOGIN_HINT_ALREADY_HANDLED = "loginHintAlreadyHandled";
    private final KeycloakSession session;
    private final WebAuthnConditionalUIAuthenticator webauthnAuth;

    public OrganizationAuthenticator(KeycloakSession session) {
        this.session = session;
        this.webauthnAuth = new WebAuthnConditionalUIAuthenticator(session, context -> this.createLoginForm((AuthenticationFlowContext)context));
    }

    @Override
    public void authenticate(AuthenticationFlowContext context) {
        OrganizationModel organization;
        OrganizationProvider provider = this.getOrganizationProvider();
        if (!Organizations.isEnabledAndOrganizationsPresent(provider)) {
            context.attempted();
            return;
        }
        String loginHint = this.session.getContext().getAuthenticationSession().getClientNote("login_hint");
        if (StringUtil.isNotBlank((String)loginHint) && !"true".equals(context.getAuthenticationSession().getClientNote(LOGIN_HINT_ALREADY_HANDLED))) {
            UserModel user = this.resolveUser(context, loginHint);
            context.setUser(user);
            context.getAuthenticationSession().setClientNote(LOGIN_HINT_ALREADY_HANDLED, "true");
        }
        if ((organization = Organizations.resolveOrganization(this.session)) == null) {
            this.initialChallenge(context);
        } else {
            AuthenticationSessionModel authSession = context.getAuthenticationSession();
            authSession.setAuthNote("kc.org", organization.getId());
            this.action(context);
        }
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        String domain;
        HttpRequest request = context.getHttpRequest();
        MultivaluedMap parameters = request.getDecodedFormParameters();
        if (this.webauthnAuth.isPasskeysEnabled() && (parameters.containsKey((Object)"authenticatorData") || parameters.containsKey((Object)"error"))) {
            this.webauthnAuth.action(context);
            if (FlowStatus.SUCCESS != context.getStatus()) {
                return;
            }
        }
        String username = (String)parameters.getFirst((Object)"username");
        RealmModel realm = context.getRealm();
        UserModel user = this.resolveUser(context, username);
        OrganizationModel organization = this.resolveOrganization(user, domain = Organizations.getEmailDomain(username));
        if (organization == null) {
            if (this.shouldUserSelectOrganization(context, user)) {
                return;
            }
            if (this.isMembershipRequired(context, null, user)) {
                return;
            }
            this.clearAuthenticationSession(context);
            context.attempted();
            return;
        }
        AuthenticationSessionModel authenticationSession = context.getAuthenticationSession();
        authenticationSession.setAuthNote("kc.org", organization.getId());
        this.session.getContext().setOrganization(organization);
        if (this.isMembershipRequired(context, organization, user)) {
            return;
        }
        if (this.tryRedirectBroker(context, organization, user, username, domain)) {
            return;
        }
        if (user == null) {
            this.unknownUserChallenge(context, organization, realm, domain != null);
            return;
        }
        if (!user.isEnabled()) {
            context.failure(AuthenticationFlowError.INVALID_USER);
            return;
        }
        if (AuthenticatorUtil.isSSOAuthentication(authenticationSession)) {
            context.success();
        } else {
            context.attempted();
        }
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return realm.isOrganizationsEnabled();
    }

    private OrganizationModel resolveOrganization(UserModel user, String domain) {
        KeycloakContext context = this.session.getContext();
        HttpRequest request = context.getHttpRequest();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        MultivaluedMap parameters = request.getDecodedFormParameters();
        List alias = (List)parameters.getOrDefault((Object)"kc.org", List.of());
        if (alias.isEmpty()) {
            OrganizationModel organization = Organizations.resolveOrganization(this.session, user, domain);
            if (AuthenticatorUtil.isSSOAuthentication(authSession) && organization != null) {
                authSession.setClientNote("kc.org", organization.getId());
            }
            return organization;
        }
        OrganizationProvider provider = this.getOrganizationProvider();
        OrganizationModel organization = provider.getByAlias((String)alias.get(0));
        if (organization == null) {
            return null;
        }
        authSession.setClientNote("kc.org", organization.getId());
        return organization;
    }

    private boolean shouldUserSelectOrganization(AuthenticationFlowContext context, UserModel user) {
        OrganizationProvider provider = this.getOrganizationProvider();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        OrganizationScope scope = OrganizationScope.valueOfScope(this.session);
        if (!OrganizationScope.ANY.equals((Object)scope) || user == null) {
            return false;
        }
        if (authSession.getClientNote("kc.org") != null) {
            return false;
        }
        Stream organizations = provider.getByMember(user);
        if (organizations.count() > 1L) {
            LoginFormsProvider form = context.form();
            form.setAttribute("user", (Object)new ProfileBean(user, this.session));
            form.setAttributeMapper((Function)new Function<Map<String, Object>, Map<String, Object>>(){

                @Override
                public Map<String, Object> apply(Map<String, Object> attributes) {
                    attributes.computeIfPresent("auth", (key, bean) -> new OrganizationAwareAuthenticationContextBean((AuthenticationContextBean)bean, false));
                    return attributes;
                }
            });
            this.clearAuthenticationSession(context);
            context.challenge(form.createForm("select-organization.ftl"));
            return true;
        }
        return false;
    }

    private boolean tryRedirectBroker(AuthenticationFlowContext context, OrganizationModel organization, UserModel user, String username, String domain) {
        if (user != null && user.credentialManager().getStoredCredentialsStream().findAny().isPresent()) {
            return false;
        }
        List<IdentityProviderModel> broker = Organizations.resolveHomeBroker(this.session, user);
        if (broker.size() == 1) {
            this.redirect(context, broker.get(0).getAlias(), user.getEmail());
            return true;
        }
        domain = domain == null ? Organizations.getEmailDomain(user) : domain;
        return this.redirect(context, organization, username, domain);
    }

    private boolean redirect(AuthenticationFlowContext context, OrganizationModel organization, String username, String domain) {
        if (domain == null) {
            return false;
        }
        IdentityProviderModel idp = organization.getIdentityProviders().filter(broker -> OrganizationModel.IdentityProviderRedirectMode.EMAIL_MATCH.isSet(broker) && domain.equalsIgnoreCase((String)broker.getConfig().get("kc.org.domain"))).findFirst().orElse(null);
        if (idp != null) {
            this.redirect(context, idp.getAlias(), username);
            return true;
        }
        idp = organization.getIdentityProviders().filter(arg_0 -> ((OrganizationModel.IdentityProviderRedirectMode)OrganizationModel.IdentityProviderRedirectMode.EMAIL_MATCH).isSet(arg_0)).filter(broker -> "ANY".equals(broker.getConfig().get("kc.org.domain"))).filter(broker -> organization.getDomains().map(OrganizationDomainModel::getName).anyMatch(domain::equals)).findFirst().orElse(null);
        if (idp != null) {
            this.redirect(context, idp.getAlias(), username);
            return true;
        }
        return false;
    }

    private UserModel resolveUser(AuthenticationFlowContext context, String username) {
        if (context.getUser() != null) {
            return context.getUser();
        }
        if (username == null) {
            return null;
        }
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)realm, (String)username);
        this.clearAuthenticationSession(context);
        context.setUser(user);
        return user;
    }

    private void unknownUserChallenge(AuthenticationFlowContext context, OrganizationModel organization, RealmModel realm, boolean domainMatch) {
        LoginFormsProvider form = context.form().setAttributeMapper(attributes -> {
            if (this.hasPublicBrokers(organization)) {
                attributes.computeIfPresent("social", (key, bean) -> new OrganizationAwareIdentityProviderBean((IdentityProviderBean)bean, true));
                attributes.computeIfPresent("realm", (key, bean) -> new OrganizationAwareRealmBean(realm));
            } else {
                attributes.computeIfPresent("social", (key, bean) -> new OrganizationAwareIdentityProviderBean((IdentityProviderBean)bean, false, true));
            }
            attributes.computeIfPresent("auth", (key, bean) -> new OrganizationAwareAuthenticationContextBean((AuthenticationContextBean)bean, false));
            return attributes;
        });
        if (domainMatch) {
            form.addError(new FormMessage("Your email domain matches the " + organization.getName() + " organization but you don't have an account yet.", new Object[0]));
        }
        context.challenge(form.createLoginUsername());
    }

    private void initialChallenge(AuthenticationFlowContext context) {
        AuthenticationSessionModel authenticationSession = context.getAuthenticationSession();
        UserModel user = context.getUser();
        if (user == null) {
            if (this.webauthnAuth.isPasskeysEnabled()) {
                this.webauthnAuth.fillContextForm(context);
            }
            context.challenge(this.createLoginForm(context));
        } else if (AuthenticatorUtil.isSSOAuthentication(authenticationSession)) {
            if (this.shouldUserSelectOrganization(context, user)) {
                return;
            }
            context.success();
        } else {
            context.attempted();
        }
    }

    private Response createLoginForm(AuthenticationFlowContext context) {
        LoginFormsProvider form = context.form().setAttributeMapper(attributes -> {
            attributes.computeIfPresent("social", (key, bean) -> new OrganizationAwareIdentityProviderBean((IdentityProviderBean)bean, false, true));
            attributes.computeIfPresent("auth", (key, bean) -> new OrganizationAwareAuthenticationContextBean((AuthenticationContextBean)bean, false));
            return attributes;
        });
        String loginHint = context.getAuthenticationSession().getClientNote("login_hint");
        if (loginHint != null) {
            form.setFormData((MultivaluedMap)new MultivaluedHashMap(Map.of("username", loginHint)));
        }
        return form.createLoginUsername();
    }

    private boolean hasPublicBrokers(OrganizationModel organization) {
        return organization.getIdentityProviders().anyMatch(Predicate.not(IdentityProviderModel::isHideOnLogin));
    }

    private OrganizationProvider getOrganizationProvider() {
        return (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
    }

    private boolean isRequiresMembership(AuthenticationFlowContext context) {
        return Boolean.parseBoolean(this.getConfig(context).getOrDefault("requiresUserMembership", Boolean.FALSE.toString()));
    }

    private Map<String, String> getConfig(AuthenticationFlowContext context) {
        return Optional.ofNullable(context.getAuthenticatorConfig()).map(AuthenticatorConfigModel::getConfig).orElse(Map.of());
    }

    private void clearAuthenticationSession(AuthenticationFlowContext context) {
        AuthenticationSessionModel authenticationSession = context.getAuthenticationSession();
        authenticationSession.removeAuthNote("kc.org");
    }

    private boolean isMembershipRequired(AuthenticationFlowContext context, OrganizationModel organization, UserModel user) {
        String failureMessage;
        String errorMessage;
        OrganizationScope scope;
        if (user == null || !this.isRequiresMembership(context)) {
            return false;
        }
        if (organization == null && OrganizationScope.SINGLE.equals((Object)(scope = OrganizationScope.valueOfScope(this.session)))) {
            organization = scope.resolveOrganizations(this.session).findAny().orElse(null);
        }
        if (organization != null && organization.isMember(user)) {
            return false;
        }
        context.setAuthenticationSelections(List.of());
        LoginFormsProvider form = context.form();
        if (organization == null) {
            errorMessage = "notMemberOfAnyOrganization";
            failureMessage = "User " + user.getUsername() + " not a member of any organization";
            form.setError(errorMessage, new Object[0]);
        } else {
            errorMessage = "notMemberOfOrganization";
            failureMessage = "User " + user.getUsername() + " not a member of organization " + organization.getAlias();
            form.setError(errorMessage, new Object[]{organization.getName()});
        }
        context.failure(AuthenticationFlowError.GENERIC_AUTHENTICATION_ERROR, form.createErrorPage(Response.Status.FORBIDDEN), failureMessage, errorMessage);
        return true;
    }
}

