/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RoleResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.utils.ProfileHelper;

@Extension(name="x-smallrye-profile-admin", value="")
public class RoleByIdResource
extends RoleResource {
    protected static final Logger logger = Logger.getLogger(RoleByIdResource.class);
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private final KeycloakSession session;

    public RoleByIdResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        super(session.getContext().getRealm());
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    @Path(value="{role-id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles (by ID)")
    @Operation(summary="Get a specific role's representation")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=RoleRepresentation.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public RoleRepresentation getRole(@Parameter(description="id of role") @PathParam(value="role-id") String id) {
        RoleModel roleModel = this.getRoleModel(id);
        this.auth.roles().requireView(roleModel);
        return this.getRole(roleModel);
    }

    protected RoleModel getRoleModel(String id) {
        RoleModel roleModel = this.realm.getRoleById(id);
        if (roleModel == null) {
            throw new NotFoundException("Could not find role with id");
        }
        return roleModel;
    }

    @Path(value="{role-id}")
    @DELETE
    @NoCache
    @Tag(name="Roles (by ID)")
    @Operation(summary="Delete the role")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden")})
    public void deleteRole(@Parameter(description="id of role") @PathParam(value="role-id") String id) {
        if (this.realm.getDefaultRole() == null) {
            logger.warnf("Default role for realm with id '%s' doesn't exist.", (Object)this.realm.getId());
        } else if (this.realm.getDefaultRole().getId().equals(id)) {
            throw ErrorResponse.error(this.realm.getDefaultRole().getName() + " is default role of the realm and cannot be removed.", Response.Status.BAD_REQUEST);
        }
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        this.deleteRole(role);
        if (role.isClientRole()) {
            this.adminEvent.resource(ResourceType.CLIENT_ROLE);
        } else {
            this.adminEvent.resource(ResourceType.REALM_ROLE);
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="{role-id}")
    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Roles (by ID)")
    @Operation(summary="Update the role")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden")})
    public void updateRole(@Parameter(description="id of role") @PathParam(value="role-id") String id, RoleRepresentation rep) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        this.updateRole(rep, role, this.realm, this.session);
        if (role.isClientRole()) {
            this.adminEvent.resource(ResourceType.CLIENT_ROLE);
        } else {
            this.adminEvent.resource(ResourceType.REALM_ROLE);
        }
        this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }

    @Path(value="{role-id}/composites")
    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Roles (by ID)")
    @Operation(summary="Make the role a composite role by associating some child roles")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden")})
    public void addComposites(@PathParam(value="role-id") String id, List<RoleRepresentation> roles) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        this.addComposites(this.auth, this.adminEvent, (UriInfo)this.session.getContext().getUri(), roles, role);
    }

    @Path(value="{role-id}/composites")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles (by ID)")
    @Operation(summary="Get role's children Returns a set of role's children provided the role is a composite.")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=RoleRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<RoleRepresentation> getRoleComposites(@PathParam(value="role-id") String id, @QueryParam(value="search") String search, @QueryParam(value="first") Integer first, @QueryParam(value="max") Integer max) {
        logger.debugf("*** getRoleComposites: '%s'", (Object)id);
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireView(role);
        if (search == null && first == null && max == null) {
            return role.getCompositesStream().map(ModelToRepresentation::toBriefRepresentation);
        }
        return role.getCompositesStream(search, first, max).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="{role-id}/composites/realm")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles (by ID)")
    @Operation(summary="Get realm-level roles that are in the role's composite")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=RoleRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<RoleRepresentation> getRealmRoleComposites(@PathParam(value="role-id") String id) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireView(role);
        return this.getRealmRoleComposites(role);
    }

    @Path(value="{role-id}/composites/clients/{clientUuid}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Roles (by ID)")
    @Operation(summary="Get client-level roles for the client that are in the role's composite")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=RoleRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public Stream<RoleRepresentation> getClientRoleComposites(@PathParam(value="role-id") String id, @PathParam(value="clientUuid") String clientUuid) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireView(role);
        ClientModel clientModel = this.realm.getClientById(clientUuid);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.getClientRoleComposites(clientModel, role);
    }

    @Path(value="{role-id}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    @Tag(name="Roles (by ID)")
    @Operation(summary="Remove a set of roles from the role's composite")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden")})
    public void deleteComposites(@Parameter(description="Role id") @PathParam(value="role-id") String id, @Parameter(description="A set of roles to be removed") List<RoleRepresentation> roles) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        this.deleteComposites(this.adminEvent, (UriInfo)this.session.getContext().getUri(), roles, role);
    }

    @Path(value="{role-id}/management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Roles (by ID)")
    @Operation(summary="Return object stating whether role Authorization permissions have been initialized or not and a reference")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ManagementPermissionReference.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public ManagementPermissionReference getManagementPermissions(@PathParam(value="role-id") String id) {
        ProfileHelper.requireFeature(Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ);
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireView(role);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.roles().isPermissionsEnabled(role)) {
            return new ManagementPermissionReference();
        }
        return RoleByIdResource.toMgmtRef(role, permissions);
    }

    public static ManagementPermissionReference toMgmtRef(RoleModel role, AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.roles().resource(role).getId());
        ref.setScopePermissions(permissions.roles().getPermissions(role));
        return ref;
    }

    @Path(value="{role-id}/management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Roles (by ID)")
    @Operation(summary="Return object stating whether role Authorization permissions have been initialized or not and a reference")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ManagementPermissionReference.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public ManagementPermissionReference setManagementPermissionsEnabled(@PathParam(value="role-id") String id, ManagementPermissionReference ref) {
        ProfileHelper.requireFeature(Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ);
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.roles().setPermissionsEnabled(role, ref.isEnabled());
        if (ref.isEnabled()) {
            return RoleByIdResource.toMgmtRef(role, permissions);
        }
        return new ManagementPermissionReference();
    }
}

