/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.UriInfo;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;

public class RedirectUtils {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;

    public static String verifyRealmRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm) {
        Set<String> validRedirects = RedirectUtils.getValidateRedirectUris(uriInfo, realm);
        return RedirectUtils.verifyRedirectUri(uriInfo, null, redirectUri, realm, validRedirects);
    }

    public static String verifyRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm, ClientModel client) {
        Set validRedirects = client.getRedirectUris();
        return RedirectUtils.verifyRedirectUri(uriInfo, client.getRootUrl(), redirectUri, realm, validRedirects);
    }

    public static Set<String> resolveValidRedirects(UriInfo uriInfo, String rootUrl, Set<String> validRedirects) {
        HashSet<String> resolveValidRedirects = new HashSet<String>();
        for (String validRedirect : validRedirects) {
            resolveValidRedirects.add(validRedirect);
            if (!validRedirect.startsWith("/")) continue;
            validRedirect = RedirectUtils.relativeToAbsoluteURI(uriInfo, rootUrl, validRedirect);
            logger.debugv("replacing relative valid redirect with: {0}", validRedirect);
            resolveValidRedirects.add(validRedirect);
        }
        return resolveValidRedirects;
    }

    private static Set<String> getValidateRedirectUris(UriInfo uriInfo, RealmModel realm) {
        HashSet<String> redirects = new HashSet<String>();
        for (ClientModel client : realm.getClients()) {
            redirects.addAll(RedirectUtils.resolveValidRedirects(uriInfo, client.getRootUrl(), client.getRedirectUris()));
        }
        return redirects;
    }

    private static String verifyRedirectUri(UriInfo uriInfo, String rootUrl, String redirectUri, RealmModel realm, Set<String> validRedirects) {
        if (redirectUri == null) {
            logger.debug("No Redirect URI parameter specified");
            return null;
        }
        if (validRedirects.isEmpty()) {
            logger.debug("No Redirect URIs supplied");
            redirectUri = null;
        } else {
            String r = (redirectUri = RedirectUtils.lowerCaseHostname(redirectUri)).indexOf(63) != -1 ? redirectUri.substring(0, redirectUri.indexOf(63)) : redirectUri;
            Set<String> resolveValidRedirects = RedirectUtils.resolveValidRedirects(uriInfo, rootUrl, validRedirects);
            boolean valid = RedirectUtils.matchesRedirects(resolveValidRedirects, r);
            if (!valid && r.startsWith("http://localhost") && r.indexOf(58, "http://localhost".length()) >= 0) {
                int i = r.indexOf(58, "http://localhost".length());
                StringBuilder sb = new StringBuilder();
                sb.append(r.substring(0, i));
                i = r.indexOf(47, i);
                if (i >= 0) {
                    sb.append(r.substring(i));
                }
                r = sb.toString();
                valid = RedirectUtils.matchesRedirects(resolveValidRedirects, r);
            }
            if (valid && redirectUri.startsWith("/")) {
                redirectUri = RedirectUtils.relativeToAbsoluteURI(uriInfo, rootUrl, redirectUri);
            }
            String string = redirectUri = valid ? redirectUri : null;
        }
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirectUri)) {
            return Urls.realmInstalledAppUrnCallback(uriInfo.getBaseUri(), realm.getName()).toString();
        }
        return redirectUri;
    }

    private static String lowerCaseHostname(String redirectUri) {
        int n = redirectUri.indexOf(47, 7);
        if (n == -1) {
            return redirectUri.toLowerCase();
        }
        return redirectUri.substring(0, n).toLowerCase() + redirectUri.substring(n);
    }

    private static String relativeToAbsoluteURI(UriInfo uriInfo, String rootUrl, String relative) {
        if (rootUrl == null || rootUrl.isEmpty()) {
            URI baseUri = uriInfo.getBaseUri();
            String uri = baseUri.getScheme() + "://" + baseUri.getHost();
            if (baseUri.getPort() != -1) {
                uri = uri + ":" + baseUri.getPort();
            }
            rootUrl = uri;
        }
        relative = rootUrl + relative;
        return relative;
    }

    private static boolean matchesRedirects(Set<String> validRedirects, String redirect) {
        for (String validRedirect : validRedirects) {
            if (validRedirect.endsWith("*")) {
                int length = validRedirect.length() - 1;
                if (redirect.startsWith(validRedirect = validRedirect.substring(0, length))) {
                    return true;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(redirect)) continue;
                return true;
            }
            if (!validRedirect.equals(redirect)) continue;
            return true;
        }
        return false;
    }
}

