/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.managers.UserSessionManager;

public class ApplicationsBean {
    private List<ApplicationEntry> applications = new LinkedList<ApplicationEntry>();

    public ApplicationsBean(KeycloakSession session, RealmModel realm, UserModel user) {
        Set<ClientModel> offlineClients = new UserSessionManager(session).findClientsWithOfflineToken(realm, user);
        List realmClients = realm.getClients();
        for (ClientModel client : realmClients) {
            UserConsentModel consent;
            Set<RoleModel> availableRoles;
            if (client.isBearerOnly() || (availableRoles = TokenManager.getAccess(null, false, client, user)).isEmpty()) continue;
            LinkedList<RoleModel> realmRolesAvailable = new LinkedList<RoleModel>();
            MultivaluedHashMap resourceRolesAvailable = new MultivaluedHashMap();
            this.processRoles(availableRoles, realmRolesAvailable, (MultivaluedHashMap<String, ClientRoleEntry>)resourceRolesAvailable);
            LinkedList<RoleModel> realmRolesGranted = new LinkedList<RoleModel>();
            MultivaluedHashMap resourceRolesGranted = new MultivaluedHashMap();
            LinkedList<String> claimsGranted = new LinkedList<String>();
            if (client.isConsentRequired() && (consent = session.users().getConsentByClient(realm, user, client.getId())) != null) {
                this.processRoles(consent.getGrantedRoles(), realmRolesGranted, (MultivaluedHashMap<String, ClientRoleEntry>)resourceRolesGranted);
                for (ProtocolMapperModel protocolMapper : consent.getGrantedProtocolMappers()) {
                    claimsGranted.add(protocolMapper.getConsentText());
                }
            }
            ArrayList<String> additionalGrants = new ArrayList<String>();
            if (offlineClients.contains(client)) {
                additionalGrants.add("${offlineToken}");
            }
            ApplicationEntry appEntry = new ApplicationEntry(realmRolesAvailable, (MultivaluedHashMap<String, ClientRoleEntry>)resourceRolesAvailable, realmRolesGranted, (MultivaluedHashMap<String, ClientRoleEntry>)resourceRolesGranted, client, claimsGranted, additionalGrants);
            this.applications.add(appEntry);
        }
    }

    private void processRoles(Set<RoleModel> inputRoles, List<RoleModel> realmRoles, MultivaluedHashMap<String, ClientRoleEntry> clientRoles) {
        for (RoleModel role : inputRoles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoles.add(role);
                continue;
            }
            ClientModel currentClient = (ClientModel)role.getContainer();
            ClientRoleEntry clientRole = new ClientRoleEntry(currentClient.getClientId(), currentClient.getName(), role.getName(), role.getDescription());
            clientRoles.add((Object)currentClient.getClientId(), (Object)clientRole);
        }
    }

    public List<ApplicationEntry> getApplications() {
        return this.applications;
    }

    public static class ClientRoleEntry {
        private final String clientId;
        private final String clientName;
        private final String roleName;
        private final String roleDescription;

        public ClientRoleEntry(String clientId, String clientName, String roleName, String roleDescription) {
            this.clientId = clientId;
            this.clientName = clientName;
            this.roleName = roleName;
            this.roleDescription = roleDescription;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getRoleDescription() {
            return this.roleDescription;
        }
    }

    public static class ApplicationEntry {
        private final List<RoleModel> realmRolesAvailable;
        private final MultivaluedHashMap<String, ClientRoleEntry> resourceRolesAvailable;
        private final List<RoleModel> realmRolesGranted;
        private final MultivaluedHashMap<String, ClientRoleEntry> resourceRolesGranted;
        private final ClientModel client;
        private final List<String> claimsGranted;
        private final List<String> additionalGrants;

        public ApplicationEntry(List<RoleModel> realmRolesAvailable, MultivaluedHashMap<String, ClientRoleEntry> resourceRolesAvailable, List<RoleModel> realmRolesGranted, MultivaluedHashMap<String, ClientRoleEntry> resourceRolesGranted, ClientModel client, List<String> claimsGranted, List<String> additionalGrants) {
            this.realmRolesAvailable = realmRolesAvailable;
            this.resourceRolesAvailable = resourceRolesAvailable;
            this.realmRolesGranted = realmRolesGranted;
            this.resourceRolesGranted = resourceRolesGranted;
            this.client = client;
            this.claimsGranted = claimsGranted;
            this.additionalGrants = additionalGrants;
        }

        public List<RoleModel> getRealmRolesAvailable() {
            return this.realmRolesAvailable;
        }

        public MultivaluedHashMap<String, ClientRoleEntry> getResourceRolesAvailable() {
            return this.resourceRolesAvailable;
        }

        public List<RoleModel> getRealmRolesGranted() {
            return this.realmRolesGranted;
        }

        public MultivaluedHashMap<String, ClientRoleEntry> getResourceRolesGranted() {
            return this.resourceRolesGranted;
        }

        public ClientModel getClient() {
            return this.client;
        }

        public List<String> getClaimsGranted() {
            return this.claimsGranted;
        }

        public List<String> getAdditionalGrants() {
            return this.additionalGrants;
        }
    }
}

