/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScriptModel;
import org.keycloak.models.UserModel;
import org.keycloak.scripting.InvocableScript;
import org.keycloak.scripting.Script;
import org.keycloak.scripting.ScriptBindingsConfigurer;
import org.keycloak.scripting.ScriptingProvider;

public class ScriptBasedAuthenticator
implements Authenticator {
    private static final Logger LOGGER = Logger.getLogger(ScriptBasedAuthenticator.class);
    static final String SCRIPT_CODE = "scriptCode";
    static final String SCRIPT_NAME = "scriptName";
    static final String SCRIPT_DESCRIPTION = "scriptDescription";
    static final String ACTION = "action";
    static final String AUTHENTICATE = "authenticate";
    static final String TEXT_JAVASCRIPT = "text/javascript";

    public void authenticate(AuthenticationFlowContext context) {
        this.tryInvoke(AUTHENTICATE, context);
    }

    public void action(AuthenticationFlowContext context) {
        this.tryInvoke(ACTION, context);
    }

    private void tryInvoke(String functionName, AuthenticationFlowContext context) {
        InvocableScript script = this.getInvocableScript(context);
        if (!script.hasFunction(functionName)) {
            return;
        }
        try {
            script.invokeFunction(functionName, new Object[]{context});
        }
        catch (NoSuchMethodException | ScriptException e) {
            LOGGER.error((Object)e);
        }
    }

    private InvocableScript getInvocableScript(AuthenticationFlowContext context) {
        final Script script = this.createAdhocScriptFromContext(context);
        ScriptBindingsConfigurer bindingsConfigurer = new ScriptBindingsConfigurer(){

            public void configureBindings(Bindings bindings) {
                bindings.put("script", (Object)script);
                bindings.put("LOG", (Object)LOGGER);
            }
        };
        ScriptingProvider scripting = context.getSession().scripting();
        return scripting.prepareScript((ScriptModel)script, bindingsConfigurer);
    }

    private Script createAdhocScriptFromContext(AuthenticationFlowContext context) {
        Map config = context.getAuthenticatorConfig().getConfig();
        String scriptName = (String)config.get(SCRIPT_NAME);
        String scriptCode = (String)config.get(SCRIPT_CODE);
        String scriptDescription = (String)config.get(SCRIPT_DESCRIPTION);
        RealmModel realm = context.getRealm();
        return new Script(null, realm.getId(), scriptName, TEXT_JAVASCRIPT, scriptCode, scriptDescription);
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

