/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class BrokeredIdentityContext {
    private String id;
    private String legacyId;
    private String username;
    private String modelUsername;
    private String email;
    private String firstName;
    private String lastName;
    private String brokerSessionId;
    private String brokerUserId;
    private String token;
    private IdentityProviderModel idpConfig;
    private IdentityProvider idp;
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private AuthenticationSessionModel authenticationSession;

    public BrokeredIdentityContext(String id) {
        if (id == null) {
            throw new RuntimeException("No identifier provider for identity.");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLegacyId() {
        return this.legacyId;
    }

    public void setLegacyId(String legacyId) {
        this.legacyId = legacyId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getModelUsername() {
        return this.modelUsername;
    }

    public void setModelUsername(String modelUsername) {
        this.modelUsername = modelUsername;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBrokerSessionId() {
        return this.brokerSessionId;
    }

    public void setBrokerSessionId(String brokerSessionId) {
        this.brokerSessionId = brokerSessionId;
    }

    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    public void setBrokerUserId(String brokerUserId) {
        this.brokerUserId = brokerUserId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public IdentityProviderModel getIdpConfig() {
        return this.idpConfig;
    }

    public void setIdpConfig(IdentityProviderModel idpConfig) {
        this.idpConfig = idpConfig;
    }

    public IdentityProvider getIdp() {
        return this.idp;
    }

    public void setIdp(IdentityProvider idp) {
        this.idp = idp;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public void setContextData(Map<String, Object> contextData) {
        this.contextData = contextData;
    }

    private Map<String, String> getSessionNotes() {
        HashMap sessionNotes = (HashMap)this.contextData.get("MAPPER_SESSION_NOTES");
        if (sessionNotes == null) {
            sessionNotes = new HashMap();
            this.contextData.put("MAPPER_SESSION_NOTES", sessionNotes);
        }
        return sessionNotes;
    }

    public void setSessionNote(String key, String value) {
        if (this.authenticationSession != null) {
            this.authenticationSession.setUserSessionNote(key, value);
        } else {
            this.getSessionNotes().put(key, value);
        }
    }

    public void addSessionNotesToUserSession(UserSessionModel userSession) {
        this.getSessionNotes().forEach((k, v) -> userSession.setNote(k, v));
    }

    public void setUserAttribute(String attributeName, String attributeValue) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(attributeValue);
        this.getContextData().put("user.attributes." + attributeName, list);
    }

    public void removeUserAttribute(String attributeName) {
        this.getContextData().remove("user.attributes." + attributeName);
    }

    public void setUserAttribute(String attributeName, List<String> attributeValues) {
        this.getContextData().put("user.attributes." + attributeName, attributeValues);
    }

    public String getUserAttribute(String attributeName) {
        List userAttribute = (List)this.getContextData().get("user.attributes." + attributeName);
        if (userAttribute == null || userAttribute.isEmpty()) {
            return null;
        }
        return (String)userAttribute.get(0);
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> entry : this.contextData.entrySet()) {
            if (!entry.getKey().startsWith("user.attributes.")) continue;
            String attrName = entry.getKey().substring("user.attributes.".length());
            List asList = (List)this.getContextData().get("user.attributes." + attrName);
            if (asList.isEmpty()) continue;
            result.put(attrName, asList);
        }
        return result;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
    }

    private Set<String> getMapperGrantedRoles() {
        HashSet roles = (HashSet)this.contextData.get("MAPPER_GRANTED_ROLES");
        if (roles == null) {
            roles = new HashSet();
            this.contextData.put("MAPPER_GRANTED_ROLES", roles);
        }
        return roles;
    }

    private Set<String> getMapperAssignedGroups() {
        HashSet groups = (HashSet)this.contextData.get("MAPPER_GRANTED_GROUPS");
        if (groups == null) {
            groups = new HashSet();
            this.contextData.put("MAPPER_GRANTED_GROUPS", groups);
        }
        return groups;
    }

    public boolean hasMapperGrantedRole(String roleName) {
        return this.getMapperGrantedRoles().contains(roleName);
    }

    public boolean hasMapperAssignedGroup(String groupId) {
        return this.getMapperAssignedGroups().contains(groupId);
    }

    public void addMapperGrantedRole(String roleName) {
        this.getMapperGrantedRoles().add(roleName);
    }

    public void addMapperAssignedGroup(String groupId) {
        this.getMapperAssignedGroups().add(groupId);
    }

    @Deprecated
    public void setName(String name) {
        if (name != null) {
            int i = name.lastIndexOf(32);
            if (i != -1) {
                this.firstName = name.substring(0, i);
                this.lastName = name.substring(i + 1);
            } else {
                this.firstName = name;
            }
        }
    }

    public String toString() {
        return "{id='" + this.id + '\'' + ", username='" + this.username + '\'' + ", email='" + this.email + '\'' + '}';
    }
}

