/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential.hash;

import org.keycloak.credential.hash.AbstractPbkdf2PasswordHashProviderFactory;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.credential.hash.PasswordHashProviderFactory;
import org.keycloak.credential.hash.Pbkdf2PasswordHashProvider;
import org.keycloak.models.KeycloakSession;

public class Pbkdf2Sha256PasswordHashProviderFactory
extends AbstractPbkdf2PasswordHashProviderFactory
implements PasswordHashProviderFactory {
    public static final String ID = "pbkdf2-sha256";
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA256";
    public static final int DEFAULT_ITERATIONS = 600000;

    public PasswordHashProvider create(KeycloakSession session) {
        return new Pbkdf2PasswordHashProvider(ID, PBKDF2_ALGORITHM, 600000, this.getMaxPaddingLength(), 256);
    }

    public String getId() {
        return ID;
    }
}

