/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.wildfly;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.undertow.ServletSamlSessionStore;
import org.keycloak.adapters.saml.wildfly.SecurityInfoHelper;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class WildflySamlSessionStore
extends ServletSamlSessionStore {
    public WildflySamlSessionStore(HttpServerExchange exchange, UndertowUserSessionManagement sessionManagement, SecurityContext securityContext, SessionIdMapper idMapper, SamlDeployment resolvedDeployment) {
        super(exchange, sessionManagement, securityContext, idMapper, resolvedDeployment);
    }

    public boolean isLoggedIn() {
        if (super.isLoggedIn()) {
            SecurityInfoHelper.propagateSessionInfo((KeycloakAccount)this.getAccount());
            return true;
        }
        return false;
    }

    public void saveAccount(SamlSession account) {
        super.saveAccount(account);
        SecurityInfoHelper.propagateSessionInfo((KeycloakAccount)account);
    }
}

