/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import java.util.Objects;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.spi.SessionIdMapper;

public class IdMapperUpdaterSessionListener
implements SessionListener {
    private final SessionIdMapper idMapper;

    public IdMapperUpdaterSessionListener(SessionIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
        Object value = session.getAttribute(SamlSession.class.getName());
        this.map(session.getId(), value);
    }

    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        if (reason != SessionListener.SessionDestroyedReason.UNDEPLOY) {
            this.unmap(session.getId(), session.getAttribute(SamlSession.class.getName()));
        }
    }

    public void attributeAdded(Session session, String name, Object value) {
        if (Objects.equals(name, SamlSession.class.getName())) {
            this.map(session.getId(), value);
        }
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        if (Objects.equals(name, SamlSession.class.getName())) {
            this.unmap(session.getId(), oldValue);
            this.map(session.getId(), newValue);
        }
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
        if (Objects.equals(name, SamlSession.class.getName())) {
            this.unmap(session.getId(), oldValue);
        }
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
        Object value = session.getAttribute(SamlSession.class.getName());
        if (value != null) {
            this.unmap(oldSessionId, value);
            this.map(session.getId(), value);
        }
    }

    private void map(String sessionId, Object value) {
        if (!(value instanceof SamlSession) || sessionId == null) {
            return;
        }
        SamlSession account = (SamlSession)value;
        this.idMapper.map(account.getSessionIndex(), account.getPrincipal().getSamlSubject(), sessionId);
    }

    private void unmap(String sessionId, Object value) {
        if (!(value instanceof SamlSession) || sessionId == null) {
            return;
        }
        SamlSession samlSession = (SamlSession)value;
        if (samlSession.getSessionIndex() != null) {
            this.idMapper.removeSession(sessionId);
        }
    }
}

