/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.undertow.UndertowSamlAuthenticator;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public abstract class AbstractSamlAuthMech
implements AuthenticationMechanism {
    public static final AttachmentKey<AuthChallenge> KEYCLOAK_CHALLENGE_ATTACHMENT_KEY = AttachmentKey.create(AuthChallenge.class);
    protected SamlDeploymentContext deploymentContext;
    protected UndertowUserSessionManagement sessionManagement;
    protected String errorPage;

    public AbstractSamlAuthMech(SamlDeploymentContext deploymentContext, UndertowUserSessionManagement sessionManagement, String errorPage) {
        this.deploymentContext = deploymentContext;
        this.sessionManagement = sessionManagement;
        this.errorPage = errorPage;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        AuthChallenge challenge = (AuthChallenge)exchange.getAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY);
        if (challenge != null) {
            if (challenge.errorPage() && this.errorPage != null) {
                Integer code = this.servePage(exchange, this.errorPage);
                return new AuthenticationMechanism.ChallengeResult(true, code);
            }
            UndertowHttpFacade facade = this.createFacade(exchange);
            if (challenge.challenge((HttpFacade)facade)) {
                return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(exchange.getResponseCode()));
            }
        }
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        AbstractSamlAuthMech.sendRedirect(exchange, location);
        return 307;
    }

    static void sendRedirect(HttpServerExchange exchange, String location) {
        String loc = exchange.getRequestScheme() + "://" + exchange.getHostAndPort() + location;
        exchange.getResponseHeaders().put(Headers.LOCATION, loc);
    }

    protected void registerNotifications(final SecurityContext securityContext) {
        NotificationReceiver logoutReceiver = new NotificationReceiver(){

            public void handleNotification(SecurityNotification notification) {
                if (notification.getEventType() != SecurityNotification.EventType.LOGGED_OUT) {
                    return;
                }
                HttpServerExchange exchange = notification.getExchange();
                UndertowHttpFacade facade = AbstractSamlAuthMech.this.createFacade(exchange);
                SamlDeployment deployment = AbstractSamlAuthMech.this.deploymentContext.resolveDeployment((HttpFacade)facade);
                SamlSessionStore sessionStore = AbstractSamlAuthMech.this.getTokenStore(exchange, (HttpFacade)facade, deployment, securityContext);
                sessionStore.logoutAccount();
            }
        };
        securityContext.registerNotificationReceiver(logoutReceiver);
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        UndertowHttpFacade facade = this.createFacade(exchange);
        SamlDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (!deployment.isConfigured()) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        SamlSessionStore sessionStore = this.getTokenStore(exchange, (HttpFacade)facade, deployment, securityContext);
        UndertowSamlAuthenticator authenticator = new UndertowSamlAuthenticator(securityContext, (HttpFacade)facade, this.deploymentContext.resolveDeployment((HttpFacade)facade), sessionStore);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            this.registerNotifications(securityContext);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        if (outcome == AuthOutcome.LOGGED_OUT) {
            securityContext.logout();
            if (deployment.getLogoutPage() != null) {
                this.redirectLogout(deployment, exchange);
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)challenge);
        }
        if (outcome == AuthOutcome.FAILED) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    protected void redirectLogout(SamlDeployment deployment, HttpServerExchange exchange) {
        String page = deployment.getLogoutPage();
        AbstractSamlAuthMech.sendRedirect(exchange, page);
        exchange.setResponseCode(302);
        exchange.endExchange();
    }

    protected UndertowHttpFacade createFacade(HttpServerExchange exchange) {
        return new UndertowHttpFacade(exchange);
    }

    protected abstract SamlSessionStore getTokenStore(HttpServerExchange var1, HttpFacade var2, SamlDeployment var3, SecurityContext var4);
}

