/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.CatalinaSamlAuthenticator;
import org.keycloak.adapters.saml.CatalinaSamlEndpoint;
import org.keycloak.adapters.saml.CatalinaSamlSessionStore;
import org.keycloak.adapters.saml.DefaultSamlDeployment;
import org.keycloak.adapters.saml.SamlAuthenticator;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.config.parsers.DeploymentBuilder;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.tomcat.CatalinaHttpFacade;
import org.keycloak.adapters.tomcat.CatalinaUserSessionManagement;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;
import org.keycloak.saml.common.exceptions.ParsingException;

public abstract class AbstractSamlAuthenticatorValve
extends FormAuthenticator
implements LifecycleListener {
    public static final String TOKEN_STORE_NOTE = "TOKEN_STORE_NOTE";
    private static final Logger log = Logger.getLogger(AbstractSamlAuthenticatorValve.class);
    protected CatalinaUserSessionManagement userSessionManagement = new CatalinaUserSessionManagement();
    protected SamlDeploymentContext deploymentContext;
    protected SessionIdMapper mapper = new InMemorySessionIdMapper();

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.cache = false;
        } else if ("after_start".equals(event.getType())) {
            this.keycloakInit();
        } else if (event.getType() == "before_stop") {
            this.beforeStop();
        }
    }

    protected void logoutInternal(Request request) {
        CatalinaHttpFacade facade = new CatalinaHttpFacade(null, request);
        SamlDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        SamlSessionStore tokenStore = this.getSessionStore(request, (HttpFacade)facade, deployment);
        tokenStore.logoutAccount();
        request.setUserPrincipal(null);
    }

    public void keycloakInit() {
        block7: {
            DefaultSamlDeployment deployment;
            String configResolverClass = this.context.getServletContext().getInitParameter("keycloak.config.resolver");
            if (configResolverClass != null) {
                try {
                    throw new RuntimeException("Not implemented yet");
                }
                catch (Exception ex) {
                    log.errorv("The specified resolver {0} could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: {1}", (Object)configResolverClass, (Object)ex.getMessage());
                    break block7;
                }
            }
            InputStream is = AbstractSamlAuthenticatorValve.getConfigInputStream(this.context);
            if (is == null) {
                log.error((Object)"No adapter configuration. Keycloak is unconfigured and will deny all requests.");
                deployment = new DefaultSamlDeployment();
            } else {
                try {
                    ResourceLoader loader = new ResourceLoader(){

                        public InputStream getResourceAsStream(String resource) {
                            return AbstractSamlAuthenticatorValve.this.context.getServletContext().getResourceAsStream(resource);
                        }
                    };
                    deployment = new DeploymentBuilder().build(is, loader);
                }
                catch (ParsingException e) {
                    throw new RuntimeException(e);
                }
            }
            this.deploymentContext = new SamlDeploymentContext((SamlDeployment)deployment);
            log.debug((Object)"Keycloak is using a per-deployment configuration.");
        }
        this.context.getServletContext().setAttribute(SamlDeploymentContext.class.getName(), (Object)this.deploymentContext);
    }

    protected void beforeStop() {
    }

    private static InputStream getConfigFromServletContext(ServletContext servletContext) {
        String xml = servletContext.getInitParameter("org.keycloak.saml.xml.adapterConfig");
        if (xml == null) {
            return null;
        }
        log.trace((Object)"**** using org.keycloak.saml.xml.adapterConfig");
        return new ByteArrayInputStream(xml.getBytes());
    }

    private static InputStream getConfigInputStream(Context context) {
        InputStream is = AbstractSamlAuthenticatorValve.getConfigFromServletContext(context.getServletContext());
        if (is == null) {
            String path = context.getServletContext().getInitParameter("keycloak.config.file");
            if (path == null) {
                log.trace((Object)"**** using /WEB-INF/keycloak-saml.xml");
                is = context.getServletContext().getResourceAsStream("/WEB-INF/keycloak-saml.xml");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    log.errorv("NOT FOUND {0}", (Object)path);
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        log.trace((Object)"*********************** SAML ************");
        CatalinaHttpFacade facade = new CatalinaHttpFacade((HttpServletResponse)response, request);
        SamlDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (request.getRequestURI().substring(request.getContextPath().length()).endsWith("/saml") && deployment != null && deployment.isConfigured()) {
            SamlSessionStore tokenStore = this.getSessionStore(request, (HttpFacade)facade, deployment);
            CatalinaSamlEndpoint authenticator = new CatalinaSamlEndpoint((HttpFacade)facade, deployment, tokenStore);
            this.executeAuthenticator(request, (HttpServletResponse)response, facade, deployment, authenticator);
            return;
        }
        this.getSessionStore(request, (HttpFacade)facade, deployment).isLoggedIn();
        super.invoke(request, response);
    }

    protected abstract GenericPrincipalFactory createPrincipalFactory();

    protected abstract boolean forwardToErrorPageInternal(Request var1, HttpServletResponse var2, Object var3) throws IOException;

    protected void forwardToLogoutPage(Request request, HttpServletResponse response, SamlDeployment deployment) {
        RequestDispatcher disp = request.getRequestDispatcher(deployment.getLogoutPage());
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        try {
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean authenticateInternal(Request request, HttpServletResponse response, Object loginConfig) throws IOException {
        log.trace((Object)"authenticateInternal");
        CatalinaHttpFacade facade = new CatalinaHttpFacade(response, request);
        SamlDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            log.trace((Object)"deployment not configured");
            return false;
        }
        SamlSessionStore tokenStore = this.getSessionStore(request, (HttpFacade)facade, deployment);
        CatalinaSamlAuthenticator authenticator = new CatalinaSamlAuthenticator((HttpFacade)facade, deployment, tokenStore);
        return this.executeAuthenticator(request, response, facade, deployment, authenticator);
    }

    protected boolean executeAuthenticator(Request request, HttpServletResponse response, CatalinaHttpFacade facade, SamlDeployment deployment, SamlAuthenticator authenticator) {
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            log.trace((Object)"AUTHENTICATED");
            return !facade.isEnded();
        }
        if (outcome == AuthOutcome.LOGGED_OUT) {
            this.logoutInternal(request);
            if (deployment.getLogoutPage() != null) {
                this.forwardToLogoutPage(request, response, deployment);
            }
            log.trace((Object)"Logging OUT");
            return false;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            log.trace((Object)"challenge");
            challenge.challenge((HttpFacade)facade);
        }
        return false;
    }

    public void keycloakSaveRequest(Request request) throws IOException {
        this.saveRequest(request, request.getSessionInternal(true));
    }

    public boolean keycloakRestoreRequest(Request request) {
        try {
            return this.restoreRequest(request, request.getSessionInternal());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected SamlSessionStore getSessionStore(Request request, HttpFacade facade, SamlDeployment resolvedDeployment) {
        SamlSessionStore store = (SamlSessionStore)request.getNote(TOKEN_STORE_NOTE);
        if (store != null) {
            return store;
        }
        store = this.createSessionStore(request, facade, resolvedDeployment);
        request.setNote(TOKEN_STORE_NOTE, (Object)store);
        return store;
    }

    protected SamlSessionStore createSessionStore(Request request, HttpFacade facade, SamlDeployment resolvedDeployment) {
        CatalinaSamlSessionStore store = new CatalinaSamlSessionStore(this.userSessionManagement, this.createPrincipalFactory(), this.mapper, request, this, facade, resolvedDeployment);
        return store;
    }
}

