/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.InputStream;
import java.net.URI;
import java.security.PublicKey;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.NameIDPolicyType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.profile.ecp.SamlEcpProfileService;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.RealmsResource;

public class SamlService
extends AuthorizationEndpointBase {
    protected static final Logger logger = Logger.getLogger(SamlService.class);

    public SamlService(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        super(realm, event, authManager);
    }

    protected Response newBrowserAuthentication(ClientSessionModel clientSession, boolean isPassive) {
        SamlProtocol samlProtocol = new SamlProtocol().setEventBuilder(this.event).setHttpHeaders(this.headers).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo);
        return this.newBrowserAuthentication(clientSession, isPassive, samlProtocol);
    }

    protected Response newBrowserAuthentication(ClientSessionModel clientSession, boolean isPassive, SamlProtocol samlProtocol) {
        return this.handleBrowserAuthenticationRequest(clientSession, samlProtocol, isPassive);
    }

    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState) {
        logger.debug((Object)"SAML GET");
        return new RedirectBindingProtocol().execute(samlRequest, samlResponse, relayState);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState) {
        logger.debug((Object)"SAML POST");
        return new PostBindingProtocol().execute(samlRequest, samlResponse, relayState);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/xml"})
    public String getDescriptor() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/idp-metadata-template.xml");
        String template = StreamUtil.readString((InputStream)is);
        template = template.replace("${idp.entityID}", RealmsResource.realmBaseUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName()}).toString());
        template = template.replace("${idp.sso.HTTP-POST}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.sso.HTTP-Redirect}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.sls.HTTP-POST}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.signing.certificate}", this.realm.getCertificatePem());
        return template;
    }

    @GET
    @Path(value="clients/{client}")
    @Produces(value={"text/html"})
    public Response idpInitiatedSSO(@PathParam(value="client") String clientUrlName, @QueryParam(value="RelayState") String relayState) {
        this.event.event(EventType.LOGIN);
        ClientModel client = null;
        for (ClientModel c : this.realm.getClients()) {
            String urlName = c.getAttribute("saml_idp_initiated_sso_url_name");
            if (urlName == null || !urlName.equals(clientUrlName)) continue;
            client = c;
            break;
        }
        if (client == null) {
            this.event.error("client_not_found");
            return ErrorPage.error((KeycloakSession)this.session, (String)"clientNotFoundMessage", (Object[])new Object[0]);
        }
        if (client.getManagementUrl() == null && client.getAttribute("saml_assertion_consumer_url_post") == null && client.getAttribute("saml_assertion_consumer_url_redirect") == null) {
            logger.error((Object)"SAML assertion consumer url not set up");
            this.event.error("invalid_redirect_uri");
            return ErrorPage.error((KeycloakSession)this.session, (String)"invalidRedirectUriMessage", (Object[])new Object[0]);
        }
        String bindingType = "post";
        if (client.getManagementUrl() == null && client.getAttribute("saml_assertion_consumer_url_post") == null && client.getAttribute("saml_assertion_consumer_url_redirect") != null) {
            bindingType = "get";
        }
        String redirect = null;
        redirect = bindingType.equals("get") ? client.getAttribute("saml_assertion_consumer_url_redirect") : client.getAttribute("saml_assertion_consumer_url_post");
        if (redirect == null) {
            redirect = client.getManagementUrl();
        }
        ClientSessionModel clientSession = this.session.sessions().createClientSession(this.realm, client);
        clientSession.setAuthMethod("saml");
        clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
        clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
        clientSession.setNote("saml_binding", "post");
        clientSession.setNote("saml_idp_initiated_login", "true");
        clientSession.setRedirectUri(redirect);
        if (relayState == null) {
            relayState = client.getAttribute("saml_idp_initiated_sso_relay_state");
        }
        if (relayState != null && !relayState.trim().equals("")) {
            clientSession.setNote("RelayState", relayState);
        }
        return this.newBrowserAuthentication(clientSession, false);
    }

    @POST
    @Consumes(value={"application/soap+xml", "text/xml"})
    public Response soapBinding(InputStream inputStream) {
        SamlEcpProfileService bindingService = new SamlEcpProfileService(this.realm, this.event, this.authManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)bindingService);
        return bindingService.authenticate(inputStream);
    }

    protected class RedirectBindingProtocol
    extends BindingProtocol {
        protected RedirectBindingProtocol() {
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder, ClientModel client) throws VerificationException {
            SamlClient samlClient = new SamlClient(client);
            if (!samlClient.requiresClientSignature()) {
                return;
            }
            PublicKey publicKey = SamlProtocolUtils.getSignatureValidationKey(client);
            SamlProtocolUtils.verifyRedirectSignature(publicKey, SamlService.this.uriInfo, "SAMLRequest");
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }

        public Response execute(String samlRequest, String samlResponse, String relayState) {
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }
    }

    protected class PostBindingProtocol
    extends BindingProtocol {
        protected PostBindingProtocol() {
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder, ClientModel client) throws VerificationException {
            SamlProtocolUtils.verifyDocumentSignature(client, documentHolder.getSamlDocument());
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponsePostBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }

        public Response execute(String samlRequest, String samlResponse, String relayState) {
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }
    }

    public abstract class BindingProtocol {
        protected Response basicChecks(String samlRequest, String samlResponse) {
            if (!this.checkSsl()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("ssl_required");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"httpsRequiredMessage", (Object[])new Object[0]);
            }
            if (!SamlService.this.realm.isEnabled()) {
                SamlService.this.event.event(EventType.LOGIN_ERROR);
                SamlService.this.event.error("realm_disabled");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"realmNotEnabledMessage", (Object[])new Object[0]);
            }
            if (samlRequest == null && samlResponse == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_token");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            return null;
        }

        protected Response handleSamlResponse(String samlResponse, String relayState) {
            SamlService.this.event.event(EventType.LOGOUT);
            SAMLDocumentHolder holder = this.extractResponseDocument(samlResponse);
            StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
            if (statusResponse.getDestination() != null && !SamlService.this.uriInfo.getAbsolutePath().toString().equals(statusResponse.getDestination())) {
                SamlService.this.event.detail("reason", "invalid_destination");
                SamlService.this.event.error("invalid_logout_response");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            SamlService.this.authManager;
            AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (boolean)false);
            if (authResult == null) {
                logger.warn((Object)"Unknown saml response.");
                SamlService.this.event.event(EventType.LOGOUT);
                SamlService.this.event.error("invalid_token");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            UserSessionModel userSession = authResult.getSession();
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.warn((Object)"Unknown saml response.");
                logger.warn((Object)"UserSession is not tagged as logging out.");
                SamlService.this.event.event(EventType.LOGOUT);
                SamlService.this.event.error("invalid_logout_response");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            logger.debug((Object)"logout response");
            SamlService.this.authManager;
            Response response = AuthenticationManager.browserLogout((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UserSessionModel)userSession, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection, (HttpHeaders)SamlService.this.headers);
            SamlService.this.event.success();
            return response;
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder documentHolder = this.extractRequestDocument(samlRequest);
            if (documentHolder == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_token");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            SAML2Object samlObject = documentHolder.getSamlObject();
            RequestAbstractType requestAbstractType = (RequestAbstractType)samlObject;
            String issuer = requestAbstractType.getIssuer().getValue();
            ClientModel client = SamlService.this.realm.getClientByClientId(issuer);
            if (client == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.client(issuer);
                SamlService.this.event.error("client_not_found");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"unknownLoginRequesterMessage", (Object[])new Object[0]);
            }
            if (!client.isEnabled()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("client_disabled");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"loginRequesterNotEnabledMessage", (Object[])new Object[0]);
            }
            if (client.isBearerOnly()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("not_allowed");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"bearerOnlyMessage", (Object[])new Object[0]);
            }
            if (!client.isStandardFlowEnabled()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("not_allowed");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"standardFlowDisabledMessage", (Object[])new Object[0]);
            }
            SamlService.this.session.getContext().setClient(client);
            try {
                this.verifySignature(documentHolder, client);
            }
            catch (VerificationException e) {
                logger.error((Object)"request validation failed", (Throwable)e);
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_signature");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequesterMessage", (Object[])new Object[0]);
            }
            logger.debug((Object)"verified request");
            if (samlObject instanceof AuthnRequestType) {
                logger.debug((Object)"** login request");
                SamlService.this.event.event(EventType.LOGIN);
                AuthnRequestType authn = (AuthnRequestType)samlObject;
                return this.loginRequest(relayState, authn, client);
            }
            if (samlObject instanceof LogoutRequestType) {
                logger.debug((Object)"** logout request");
                SamlService.this.event.event(EventType.LOGOUT);
                LogoutRequestType logout = (LogoutRequestType)samlObject;
                return this.logoutRequest(logout, client, relayState);
            }
            SamlService.this.event.event(EventType.LOGIN);
            SamlService.this.event.error("invalid_token");
            return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
        }

        protected abstract void verifySignature(SAMLDocumentHolder var1, ClientModel var2) throws VerificationException;

        protected abstract SAMLDocumentHolder extractRequestDocument(String var1);

        protected abstract SAMLDocumentHolder extractResponseDocument(String var1);

        protected Response loginRequest(String relayState, AuthnRequestType requestAbstractType, ClientModel client) {
            SamlClient samlClient = new SamlClient(client);
            if (requestAbstractType.getDestination() != null && !SamlService.this.uriInfo.getAbsolutePath().equals(requestAbstractType.getDestination())) {
                SamlService.this.event.detail("reason", "invalid_destination");
                SamlService.this.event.error("invalid_authn_request");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            String bindingType = this.getBindingType(requestAbstractType);
            if (samlClient.forcePostBinding()) {
                bindingType = "post";
            }
            String redirect = null;
            URI redirectUri = requestAbstractType.getAssertionConsumerServiceURL();
            if (redirectUri != null && !"null".equals(redirectUri)) {
                redirect = RedirectUtils.verifyRedirectUri((UriInfo)SamlService.this.uriInfo, (String)redirectUri.toString(), (RealmModel)SamlService.this.realm, (ClientModel)client);
            } else {
                redirect = bindingType.equals("post") ? client.getAttribute("saml_assertion_consumer_url_post") : client.getAttribute("saml_assertion_consumer_url_redirect");
                if (redirect == null) {
                    redirect = client.getManagementUrl();
                }
            }
            if (redirect == null) {
                SamlService.this.event.error("invalid_redirect_uri");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRedirectUriMessage", (Object[])new Object[0]);
            }
            ClientSessionModel clientSession = SamlService.this.session.sessions().createClientSession(SamlService.this.realm, client);
            clientSession.setAuthMethod("saml");
            clientSession.setRedirectUri(redirect);
            clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
            clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
            clientSession.setNote("saml_binding", bindingType);
            clientSession.setNote("RelayState", relayState);
            clientSession.setNote("SAML_REQUEST_ID", requestAbstractType.getID());
            NameIDPolicyType nameIdPolicy = requestAbstractType.getNameIDPolicy();
            if (nameIdPolicy != null && !samlClient.forceNameIDFormat()) {
                String nameIdFormat = nameIdPolicy.getFormat().toString();
                if (this.isSupportedNameIdFormat(nameIdFormat)) {
                    clientSession.setNote("NAMEID_FORMAT", nameIdFormat);
                } else {
                    SamlService.this.event.detail("reason", "unsupported_nameid_format");
                    SamlService.this.event.error("invalid_authn_request");
                    return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"unsupportedNameIdFormatMessage", (Object[])new Object[0]);
                }
            }
            return SamlService.this.newBrowserAuthentication(clientSession, requestAbstractType.isIsPassive());
        }

        protected String getBindingType(AuthnRequestType requestAbstractType) {
            URI requestedProtocolBinding = requestAbstractType.getProtocolBinding();
            if (requestedProtocolBinding != null) {
                if (JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get().equals(requestedProtocolBinding.toString())) {
                    return "post";
                }
                return "get";
            }
            return this.getBindingType();
        }

        private boolean isSupportedNameIdFormat(String nameIdFormat) {
            return nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get());
        }

        protected abstract String getBindingType();

        protected Response logoutRequest(LogoutRequestType logoutRequest, ClientModel client, String relayState) {
            SamlClient samlClient = new SamlClient(client);
            if (logoutRequest.getDestination() != null && !SamlService.this.uriInfo.getAbsolutePath().equals(logoutRequest.getDestination())) {
                SamlService.this.event.detail("reason", "invalid_destination");
                SamlService.this.event.error("invalid_logout_request");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            SamlService.this.authManager;
            AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (boolean)false);
            if (authResult != null) {
                String logoutBinding = this.getBindingType();
                if ("true".equals(samlClient.forcePostBinding())) {
                    logoutBinding = "post";
                }
                String bindingUri = SamlProtocol.getLogoutServiceUrl(SamlService.this.uriInfo, client, logoutBinding);
                UserSessionModel userSession = authResult.getSession();
                userSession.setNote("SAML_LOGOUT_BINDING_URI", bindingUri);
                if (samlClient.requiresRealmSignature()) {
                    userSession.setNote("saml.logout.signature.algorithm", samlClient.getSignatureAlgorithm().toString());
                }
                if (relayState != null) {
                    userSession.setNote("SAML_LOGOUT_RELAY_STATE", relayState);
                }
                userSession.setNote("SAML_LOGOUT_REQUEST_ID", logoutRequest.getID());
                userSession.setNote("saml.logout.binding", logoutBinding);
                userSession.setNote("SAML_LOGOUT_CANONICALIZATION", samlClient.getCanonicalizationMethod());
                userSession.setNote("KEYCLOAK_LOGOUT_PROTOCOL", "saml");
                for (ClientSessionModel clientSession : userSession.getClientSessions()) {
                    if (!clientSession.getClient().getId().equals(client.getId())) continue;
                    clientSession.setAction(ClientSessionModel.Action.LOGGED_OUT.name());
                }
                logger.debug((Object)"browser Logout");
                SamlService.this.authManager;
                return AuthenticationManager.browserLogout((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UserSessionModel)userSession, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection, (HttpHeaders)SamlService.this.headers);
            }
            if (logoutRequest.getSessionIndex() != null) {
                for (String sessionIndex : logoutRequest.getSessionIndex()) {
                    ClientSessionModel clientSession = SamlService.this.session.sessions().getClientSession(SamlService.this.realm, sessionIndex);
                    if (clientSession == null) continue;
                    UserSessionModel userSession = clientSession.getUserSession();
                    if (clientSession.getClient().getClientId().equals(client.getClientId())) {
                        clientSession.setAction(ClientSessionModel.Action.LOGGED_OUT.name());
                        if (userSession != null) {
                            for (ClientSessionModel clientSession2 : userSession.getClientSessions()) {
                                if (!clientSession2.getClient().getId().equals(client.getId())) continue;
                                clientSession2.setAction(ClientSessionModel.Action.LOGGED_OUT.name());
                            }
                        }
                    }
                    try {
                        SamlService.this.authManager;
                        AuthenticationManager.backchannelLogout((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UserSessionModel)userSession, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection, (HttpHeaders)SamlService.this.headers, (boolean)true);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failure with backchannel logout", (Throwable)e);
                    }
                }
            }
            String logoutBinding = this.getBindingType();
            String logoutBindingUri = SamlProtocol.getLogoutServiceUrl(SamlService.this.uriInfo, client, logoutBinding);
            String logoutRelayState = relayState;
            SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
            builder.logoutRequestID(logoutRequest.getID());
            builder.destination(logoutBindingUri);
            builder.issuer(RealmsResource.realmBaseUrl((UriInfo)SamlService.this.uriInfo).build(new Object[]{SamlService.this.realm.getName()}).toString());
            JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder().relayState(logoutRelayState);
            if (samlClient.requiresRealmSignature()) {
                SignatureAlgorithm algorithm = samlClient.getSignatureAlgorithm();
                ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signatureAlgorithm(algorithm)).signWith(SamlService.this.realm.getPrivateKey(), SamlService.this.realm.getPublicKey(), SamlService.this.realm.getCertificate())).signDocument();
            }
            try {
                if ("post".equals(logoutBinding)) {
                    return binding.postBinding(builder.buildDocument()).response(logoutBindingUri);
                }
                return binding.redirectBinding(builder.buildDocument()).response(logoutBindingUri);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean checkSsl() {
            if (SamlService.this.uriInfo.getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !SamlService.this.realm.getSslRequired().isRequired(SamlService.this.clientConnection);
        }
    }
}

