/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.IOException;
import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.namespace.QName;
import org.keycloak.protocol.saml.SALM2LoginResponseBuilder;
import org.keycloak.protocol.saml.SignatureAlgorithm;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2BindingBuilder<T extends SAML2BindingBuilder> {
    protected KeyPair signingKeyPair;
    protected X509Certificate signingCertificate;
    protected boolean sign;
    protected boolean signAssertions;
    protected SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RSA_SHA1;
    protected String relayState;
    protected String destination;
    protected String responseIssuer;
    protected int encryptionKeySize = 128;
    protected PublicKey encryptionPublicKey;
    protected String encryptionAlgorithm = "AES";
    protected boolean encrypt;

    public T signDocument() {
        this.sign = true;
        return (T)this;
    }

    public T signAssertions() {
        this.signAssertions = true;
        return (T)this;
    }

    public T signWith(KeyPair keyPair) {
        this.signingKeyPair = keyPair;
        return (T)this;
    }

    public T signWith(PrivateKey privateKey, PublicKey publicKey) {
        this.signingKeyPair = new KeyPair(publicKey, privateKey);
        return (T)this;
    }

    public T signWith(KeyPair keyPair, X509Certificate cert) {
        this.signingKeyPair = keyPair;
        this.signingCertificate = cert;
        return (T)this;
    }

    public T signWith(PrivateKey privateKey, PublicKey publicKey, X509Certificate cert) {
        this.signingKeyPair = new KeyPair(publicKey, privateKey);
        this.signingCertificate = cert;
        return (T)this;
    }

    public T signatureAlgorithm(SignatureAlgorithm alg) {
        this.signatureAlgorithm = alg;
        return (T)this;
    }

    public T encrypt(PublicKey publicKey) {
        this.encrypt = true;
        this.encryptionPublicKey = publicKey;
        return (T)this;
    }

    public T encryptionAlgorithm(String alg) {
        this.encryptionAlgorithm = alg;
        return (T)this;
    }

    public T encryptionKeySize(int size) {
        this.encryptionKeySize = size;
        return (T)this;
    }

    public T destination(String destination) {
        this.destination = destination;
        return (T)this;
    }

    public T responseIssuer(String issuer) {
        this.responseIssuer = issuer;
        return (T)this;
    }

    public T relayState(String relayState) {
        this.relayState = relayState;
        return (T)this;
    }

    private String getSAMLNSPrefix(Document samlResponseDocument) {
        Node assertionElement = samlResponseDocument.getDocumentElement().getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()).item(0);
        if (assertionElement == null) {
            throw new IllegalStateException("Unable to find assertion in saml response document");
        }
        return assertionElement.getPrefix();
    }

    protected void encryptDocument(Document samlDocument) throws ProcessingException {
        String samlNSPrefix = this.getSAMLNSPrefix(samlDocument);
        try {
            QName encryptedAssertionElementQName = new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ENCRYPTED_ASSERTION.get(), samlNSPrefix);
            byte[] secret = WSTrustUtil.createRandomSecret((int)(this.encryptionKeySize / 8));
            SecretKeySpec secretKey = new SecretKeySpec(secret, this.encryptionAlgorithm);
            XMLEncryptionUtil.encryptElement((QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get(), samlNSPrefix), (Document)samlDocument, (PublicKey)this.encryptionPublicKey, (SecretKey)secretKey, (int)this.encryptionKeySize, (QName)encryptedAssertionElementQName, (boolean)true);
        }
        catch (Exception e) {
            throw new ProcessingException("failed to encrypt", (Throwable)e);
        }
    }

    protected void signDocument(Document samlDocument) throws ProcessingException {
        String signatureMethod = this.signatureAlgorithm.getXmlSignatureMethod();
        String signatureDigestMethod = this.signatureAlgorithm.getXmlSignatureDigestMethod();
        SAML2Signature samlSignature = new SAML2Signature();
        if (signatureMethod != null) {
            samlSignature.setSignatureMethod(signatureMethod);
        }
        if (signatureDigestMethod != null) {
            samlSignature.setDigestMethod(signatureDigestMethod);
        }
        Node nextSibling = samlSignature.getNextSiblingOfIssuer(samlDocument);
        samlSignature.setNextSibling(nextSibling);
        if (this.signingCertificate != null) {
            samlSignature.setX509Certificate(this.signingCertificate);
        }
        samlSignature.signSAMLDocument(samlDocument, this.signingKeyPair);
    }

    protected void signAssertion(Document samlDocument) throws ProcessingException {
        Document temporaryDocument;
        Element originalAssertionElement = org.picketlink.common.util.DocumentUtil.getChildElement((Element)samlDocument.getDocumentElement(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()));
        if (originalAssertionElement == null) {
            return;
        }
        Node clonedAssertionElement = originalAssertionElement.cloneNode(true);
        try {
            temporaryDocument = org.picketlink.common.util.DocumentUtil.createDocument();
        }
        catch (ConfigurationException e) {
            throw new ProcessingException((Throwable)e);
        }
        temporaryDocument.adoptNode(clonedAssertionElement);
        temporaryDocument.appendChild(clonedAssertionElement);
        this.signDocument(temporaryDocument);
        samlDocument.adoptNode(clonedAssertionElement);
        Element parentNode = (Element)originalAssertionElement.getParentNode();
        parentNode.replaceChild(clonedAssertionElement, originalAssertionElement);
    }

    protected Response buildResponse(Document responseDoc) throws ProcessingException, ConfigurationException, IOException {
        String str = this.buildHtmlPostResponse(responseDoc);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        return Response.ok((Object)str, (MediaType)MediaType.TEXT_HTML_TYPE).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
    }

    protected String buildHtmlPostResponse(Document responseDoc) throws ProcessingException, ConfigurationException, IOException {
        byte[] responseBytes = org.picketlink.common.util.DocumentUtil.getDocumentAsString((Document)responseDoc).getBytes("UTF-8");
        String samlResponse = PostBindingUtil.base64Encode((String)new String(responseBytes));
        return this.buildHtml(samlResponse);
    }

    protected String buildHtml(String samlResponse) {
        if (this.destination == null) {
            throw SALM2LoginResponseBuilder.logger.nullValueError("Destination is null");
        }
        StringBuilder builder = new StringBuilder();
        String key = "SAMLResponse";
        builder.append("<HTML>");
        builder.append("<HEAD>");
        builder.append("<TITLE>HTTP Post Binding Response (Response)</TITLE>");
        builder.append("</HEAD>");
        builder.append("<BODY Onload=\"document.forms[0].submit()\">");
        builder.append("<FORM METHOD=\"POST\" ACTION=\"" + this.destination + "\">");
        builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"" + key + "\"" + " VALUE=\"" + samlResponse + "\"/>");
        if (StringUtil.isNotNull((String)this.relayState)) {
            builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"RelayState\" VALUE=\"" + this.relayState + "\"/>");
        }
        builder.append("<NOSCRIPT>");
        builder.append("<P>JavaScript is disabled. We strongly recommend to enable it. Click the button below to continue.</P>");
        builder.append("<INPUT TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
        builder.append("</NOSCRIPT>");
        builder.append("</FORM></BODY></HTML>");
        return builder.toString();
    }

    protected String base64Encoded(Document document) throws ConfigurationException, ProcessingException, IOException {
        byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)document).getBytes("UTF-8");
        return RedirectBindingUtil.deflateBase64URLEncode((byte[])responseBytes);
    }

    protected URI generateRedirectUri(String samlParameterName, Document document) throws ConfigurationException, ProcessingException, IOException {
        UriBuilder builder = UriBuilder.fromUri((String)this.destination).replaceQuery(null).queryParam(samlParameterName, new Object[]{this.base64Encoded(document)});
        if (this.relayState != null) {
            builder.queryParam("RelayState", new Object[]{this.relayState});
        }
        if (this.sign) {
            builder.queryParam("SigAlg", new Object[]{this.signatureAlgorithm.getJavaSignatureAlgorithm()});
            URI uri = builder.build(new Object[0]);
            String rawQuery = uri.getRawQuery();
            Signature signature = this.signatureAlgorithm.createSignature();
            byte[] sig = new byte[]{};
            try {
                signature.initSign(this.signingKeyPair.getPrivate());
                signature.update(rawQuery.getBytes("UTF-8"));
                sig = signature.sign();
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
            String encodedSig = RedirectBindingUtil.base64URLEncode((byte[])sig);
            builder.queryParam("Signature", new Object[]{encodedSig});
        }
        return builder.build(new Object[0]);
    }

    public class RedirectBindingBuilder {
        protected Document document;

        public RedirectBindingBuilder(Document document) throws ProcessingException {
            this.document = document;
            if (SAML2BindingBuilder.this.signAssertions) {
                SAML2BindingBuilder.this.signAssertion(document);
            }
        }

        public Document getDocument() {
            return this.document;
        }

        public URI responseUri() throws ConfigurationException, ProcessingException, IOException {
            return SAML2BindingBuilder.this.generateRedirectUri("SAMLResponse", this.document);
        }

        public Response response() throws ProcessingException, ConfigurationException, IOException {
            URI uri = this.responseUri();
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            return Response.status((int)302).location(uri).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
        }
    }

    public class PostBindingBuilder {
        protected Document document;

        public PostBindingBuilder(Document document) throws ProcessingException {
            this.document = document;
            if (SAML2BindingBuilder.this.signAssertions) {
                SAML2BindingBuilder.this.signAssertion(document);
            }
            if (SAML2BindingBuilder.this.sign) {
                SAML2BindingBuilder.this.signDocument(document);
            }
        }

        public String encoded() throws ProcessingException, ConfigurationException, IOException {
            byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)this.document).getBytes("UTF-8");
            return PostBindingUtil.base64Encode((String)new String(responseBytes));
        }

        public Document getDocument() {
            return this.document;
        }

        public String htmlResponse() throws ProcessingException, ConfigurationException, IOException {
            return SAML2BindingBuilder.this.buildHtml(this.encoded());
        }

        public Response response() throws ConfigurationException, ProcessingException, IOException {
            return SAML2BindingBuilder.this.buildResponse(this.document);
        }
    }
}

