/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jetty;

import javax.servlet.ServletRequest;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.keycloak.adapters.jetty.spi.JettyUserSessionManagement;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.jetty.AbstractSamlAuthenticator;
import org.keycloak.adapters.saml.jetty.Jetty9SamlSessionStore;
import org.keycloak.adapters.saml.jetty.JettyAdapterSessionStore;
import org.keycloak.adapters.saml.jetty.JettySamlSessionStore;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.HttpFacade;

public class KeycloakSamlAuthenticator
extends AbstractSamlAuthenticator {
    protected Request resolveRequest(ServletRequest req) {
        return req instanceof Request ? (Request)req : HttpChannel.getCurrentHttpChannel().getRequest();
    }

    public Authentication createAuthentication(UserIdentity userIdentity) {
        return new AbstractSamlAuthenticator.KeycloakAuthentication(this.getAuthMethod(), userIdentity){

            public void logout() {
                KeycloakSamlAuthenticator.this.logoutCurrent(HttpChannel.getCurrentHttpChannel().getRequest());
            }
        };
    }

    public AdapterSessionStore createSessionTokenStore(Request request, SamlDeployment resolvedDeployment) {
        return new JettyAdapterSessionStore(request);
    }

    protected JettySamlSessionStore createJettySamlSessionStore(Request request, HttpFacade facade, SamlDeployment resolvedDeployment) {
        Jetty9SamlSessionStore store = new Jetty9SamlSessionStore(request, this.createSessionTokenStore(request, resolvedDeployment), facade, this.idMapper, new JettyUserSessionManagement(request.getSessionManager()), resolvedDeployment);
        return store;
    }
}

