/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jetty;

import javax.servlet.ServletRequest;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.keycloak.adapters.jetty.spi.JettySessionManager;
import org.keycloak.adapters.jetty.spi.JettyUserSessionManagement;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.jetty.AbstractSamlAuthenticator;
import org.keycloak.adapters.saml.jetty.Jetty9SamlSessionStore;
import org.keycloak.adapters.saml.jetty.Jetty9SessionManager;
import org.keycloak.adapters.saml.jetty.JettyAdapterSessionStore;
import org.keycloak.adapters.saml.jetty.JettySamlSessionStore;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.HttpFacade;

public class KeycloakSamlAuthenticator
extends AbstractSamlAuthenticator {
    public AdapterSessionStore createSessionTokenStore(Request request, SamlDeployment resolvedDeployment) {
        return new JettyAdapterSessionStore(request);
    }

    public JettyUserSessionManagement createSessionManagement(Request request) {
        return new JettyUserSessionManagement((JettySessionManager)new Jetty9SessionManager(request.getSessionManager()));
    }

    protected Request resolveRequest(ServletRequest req) {
        return req instanceof Request ? (Request)req : HttpChannel.getCurrentHttpChannel().getRequest();
    }

    public Authentication createAuthentication(UserIdentity userIdentity, Request request) {
        return new AbstractSamlAuthenticator.KeycloakAuthentication(this.getAuthMethod(), userIdentity){

            public void logout() {
                KeycloakSamlAuthenticator.this.logoutCurrent(HttpChannel.getCurrentHttpChannel().getRequest());
            }
        };
    }

    protected JettySamlSessionStore createJettySamlSessionStore(Request request, HttpFacade facade, SamlDeployment resolvedDeployment) {
        Jetty9SamlSessionStore store = new Jetty9SamlSessionStore(request, this.createSessionTokenStore(request, resolvedDeployment), facade, this.idMapper, this.createSessionManagement(request), resolvedDeployment);
        return store;
    }
}

