/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jetty;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Request;
import org.jboss.logging.Logger;
import org.keycloak.adapters.jetty.spi.JettyUserSessionManagement;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.SessionIdMapper;

public class JettySamlSessionStore
implements SamlSessionStore {
    public static final String SAML_REDIRECT_URI = "SAML_REDIRECT_URI";
    private static final Logger log = Logger.getLogger(JettySamlSessionStore.class);
    private Request request;
    protected AdapterSessionStore sessionStore;
    protected HttpFacade facade;
    protected SessionIdMapper idMapper;
    protected JettyUserSessionManagement sessionManagement;

    public JettySamlSessionStore(Request request, AdapterSessionStore sessionStore, HttpFacade facade, SessionIdMapper idMapper, JettyUserSessionManagement sessionManagement) {
        this.request = request;
        this.sessionStore = sessionStore;
        this.facade = facade;
        this.idMapper = idMapper;
        this.sessionManagement = sessionManagement;
    }

    public void setCurrentAction(SamlSessionStore.CurrentAction action) {
        if (action == SamlSessionStore.CurrentAction.NONE && this.request.getSession(false) == null) {
            return;
        }
        this.request.getSession().setAttribute("SAML_CURRENT_ACTION", (Object)action);
    }

    public boolean isLoggingIn() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttribute("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_IN;
    }

    public boolean isLoggingOut() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttribute("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_OUT;
    }

    public void logoutAccount() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            SamlSession samlSession = (SamlSession)session.getAttribute(SamlSession.class.getName());
            if (samlSession != null) {
                if (samlSession.getSessionIndex() != null) {
                    this.idMapper.removeSession(session.getId());
                }
                session.removeAttribute(SamlSession.class.getName());
            }
            session.removeAttribute(SAML_REDIRECT_URI);
        }
    }

    public void logoutByPrincipal(String principal) {
        Set sessions = this.idMapper.getUserSessions(principal);
        if (sessions != null) {
            LinkedList<String> ids = new LinkedList<String>();
            ids.addAll(sessions);
            this.logoutSessionIds(ids);
            for (String id : ids) {
                this.idMapper.removeSession(id);
            }
        }
    }

    public void logoutBySsoId(List<String> ssoIds) {
        if (ssoIds == null) {
            return;
        }
        LinkedList<String> sessionIds = new LinkedList<String>();
        for (String id : ssoIds) {
            String sessionId = this.idMapper.getSessionFromSSO(id);
            if (sessionId == null) continue;
            sessionIds.add(sessionId);
            this.idMapper.removeSession(sessionId);
        }
        this.logoutSessionIds(sessionIds);
    }

    protected void logoutSessionIds(List<String> sessionIds) {
        if (sessionIds == null || sessionIds.isEmpty()) {
            return;
        }
        this.sessionManagement.logoutHttpSessions(sessionIds);
    }

    public boolean isLoggedIn() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        if (session == null) {
            log.debug((Object)"session was null, returning null");
            return false;
        }
        SamlSession samlSession = (SamlSession)session.getAttribute(SamlSession.class.getName());
        if (samlSession == null) {
            log.debug((Object)"SamlSession was not in session, returning null");
            return false;
        }
        this.restoreRequest();
        return true;
    }

    public void saveAccount(SamlSession account) {
        HttpSession session = this.request.getSession(true);
        session.setAttribute(SamlSession.class.getName(), (Object)account);
        this.idMapper.map(account.getSessionIndex(), account.getPrincipal().getSamlSubject(), session.getId());
    }

    public SamlSession getAccount() {
        HttpSession session = this.request.getSession(true);
        return (SamlSession)session.getAttribute(SamlSession.class.getName());
    }

    public String getRedirectUri() {
        return (String)this.request.getSession(true).getAttribute(SAML_REDIRECT_URI);
    }

    public void saveRequest() {
        this.sessionStore.saveRequest();
        this.request.getSession(true).setAttribute(SAML_REDIRECT_URI, (Object)this.facade.getRequest().getURI());
    }

    public boolean restoreRequest() {
        return this.sessionStore.restoreRequest();
    }
}

