/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v1.assertion.SAML11NameIdentifierType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectConfirmationType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.util.SAML11ParserUtil;

public class SAML11SubjectParser
implements StaxParser {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StaxParserUtil.getNextEvent(xmlEventReader);
        SAML11SubjectType subject = new SAML11SubjectType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches(endElement, JBossSAMLConstants.SUBJECT.get())) {
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(StaxParserUtil.getElementName(endElement), xmlEvent.getLocation());
            }
            StartElement peekedElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (peekedElement == null) break;
            String tag = StaxParserUtil.getElementName(peekedElement);
            if ("NameIdentifier".equalsIgnoreCase(tag)) {
                Attribute nameQAtt;
                peekedElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                String val = StaxParserUtil.getElementText(xmlEventReader);
                SAML11NameIdentifierType nameID = new SAML11NameIdentifierType(val);
                Attribute formatAtt = peekedElement.getAttributeByName(new QName("Format"));
                if (formatAtt != null) {
                    nameID.setFormat(URI.create(StaxParserUtil.getAttributeValue(formatAtt)));
                }
                if ((nameQAtt = peekedElement.getAttributeByName(new QName("NameQualifier"))) != null) {
                    nameID.setNameQualifier(StaxParserUtil.getAttributeValue(nameQAtt));
                }
                SAML11SubjectType.SAML11SubjectTypeChoice subChoice = new SAML11SubjectType.SAML11SubjectTypeChoice(nameID);
                subject.setChoice(subChoice);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT_CONFIRMATION.get().equalsIgnoreCase(tag)) {
                SAML11SubjectConfirmationType subjectConfirmationType = SAML11ParserUtil.parseSAML11SubjectConfirmation(xmlEventReader);
                subject.setSubjectConfirmation(subjectConfirmationType);
                continue;
            }
            throw logger.parserUnknownTag(tag, peekedElement.getLocation());
        }
        return subject;
    }
}

