/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.metadata;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.ExtensionsType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.AbstractDescriptorParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLEntityDescriptorParser;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class SAMLEntitiesDescriptorParser
extends AbstractDescriptorParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final String EDT = JBossSAMLConstants.ENTITIES_DESCRIPTOR.get();

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute cacheDuration;
        Attribute name;
        Attribute id;
        xmlEventReader = this.filterWhiteSpaceCharacters(xmlEventReader);
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.EDT);
        EntitiesDescriptorType entitiesDescriptorType = new EntitiesDescriptorType();
        Attribute validUntil = startElement.getAttributeByName(new QName(JBossSAMLConstants.VALID_UNTIL.get()));
        if (validUntil != null) {
            String validUntilValue = StaxParserUtil.getAttributeValue(validUntil);
            entitiesDescriptorType.setValidUntil(XMLTimeUtil.parse(validUntilValue));
        }
        if ((id = startElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()))) != null) {
            entitiesDescriptorType.setID(StaxParserUtil.getAttributeValue(id));
        }
        if ((name = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME.get()))) != null) {
            entitiesDescriptorType.setName(StaxParserUtil.getAttributeValue(name));
        }
        if ((cacheDuration = startElement.getAttributeByName(new QName(JBossSAMLConstants.CACHE_DURATION.get()))) != null) {
            entitiesDescriptorType.setCacheDuration(XMLTimeUtil.parseAsDuration(StaxParserUtil.getAttributeValue(cacheDuration)));
        }
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                StaxParserUtil.validate((EndElement)xmlEvent, this.EDT);
                StaxParserUtil.getNextEndElement(xmlEventReader);
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ENTITY_DESCRIPTOR.get().equals(localPart)) {
                SAMLEntityDescriptorParser entityParser = new SAMLEntityDescriptorParser();
                entitiesDescriptorType.addEntityDescriptor(entityParser.parse(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                entitiesDescriptorType.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ENTITIES_DESCRIPTOR.get().equalsIgnoreCase(localPart)) {
                SAMLEntitiesDescriptorParser parser = new SAMLEntitiesDescriptorParser();
                entitiesDescriptorType.addEntityDescriptor(parser.parse(xmlEventReader));
                continue;
            }
            if (localPart.equals(JBossSAMLConstants.SIGNATURE.get())) {
                entitiesDescriptorType.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return entitiesDescriptorType;
    }

    @Override
    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(this.EDT);
    }

    private ExtensionsType parseExtensions(XMLEventReader xmlEventReader) throws ParsingException {
        ExtensionsType extensions = new ExtensionsType();
        Element extElement = StaxParserUtil.getDOMElement(xmlEventReader);
        extensions.setElement(extElement);
        return extensions;
    }
}

