/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.saml.as7;

import java.util.ArrayList;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ValveMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.keycloak.adapters.saml.jbossweb.SamlAuthenticatorValve;

public class KeycloakAdapterConfigDeploymentProcessor
implements DeploymentUnitProcessor {
    protected Logger log = Logger.getLogger(KeycloakAdapterConfigDeploymentProcessor.class);
    public static final String AUTH_DATA_PARAM_NAME = "org.keycloak.saml.adapterConfig";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        LoginConfigMetaData loginConfig;
        boolean webRequiresKC;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        boolean bl = webRequiresKC = (loginConfig = webMetaData.getLoginConfig()) != null && "KEYCLOAK-SAML".equalsIgnoreCase(loginConfig.getAuthMethod());
        if (webRequiresKC) {
            this.log.debug((Object)("Setting up KEYCLOAK-SAML auth method for WAR: " + deploymentName));
            this.addValve(webMetaData);
        }
    }

    private void addValve(JBossWebMetaData webMetaData) {
        ArrayList<ValveMetaData> valves = webMetaData.getValves();
        if (valves == null) {
            valves = new ArrayList<ValveMetaData>(1);
            webMetaData.setValves(valves);
        }
        ValveMetaData valve = new ValveMetaData();
        valve.setValveClass(SamlAuthenticatorValve.class.getName());
        valve.setModule("org.keycloak.keycloak-saml-as7-adapter");
        valves.add(valve);
    }

    public void undeploy(DeploymentUnit du) {
    }
}

