/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jbossweb.infinispan;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.notifications.cachelistener.event.TransactionalEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.jboss.logging.Logger;
import org.keycloak.adapters.spi.SessionIdMapper;

@Listener
public class SsoSessionCacheListener {
    private static final Logger LOG = Logger.getLogger(SsoSessionCacheListener.class);
    private final ConcurrentMap<GlobalTransaction, Queue<Event>> map = new ConcurrentHashMap<GlobalTransaction, Queue<Event>>();
    private final SessionIdMapper idMapper;
    private final Cache<String, String[]> ssoCache;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public SsoSessionCacheListener(Cache<String, String[]> ssoCache, SessionIdMapper idMapper) {
        this.ssoCache = ssoCache;
        this.idMapper = idMapper;
    }

    @TransactionRegistered
    public void startTransaction(TransactionRegisteredEvent event) {
        this.map.put(event.getGlobalTransaction(), new ConcurrentLinkedQueue());
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        this.executor.shutdownNow();
    }

    @CacheEntryCreated
    @CacheEntryRemoved
    @CacheEntryModified
    public void addEvent(TransactionalEvent event) {
        if (event.getGlobalTransaction() != null) {
            ((Queue)this.map.get(event.getGlobalTransaction())).add(event);
        } else {
            this.processEvent((Event)event);
        }
    }

    @TransactionCompleted
    public void endTransaction(TransactionCompletedEvent event) {
        Queue events = (Queue)this.map.remove(event.getGlobalTransaction());
        if (events == null || !event.isTransactionSuccessful()) {
            return;
        }
        if (event.isOriginLocal()) {
            return;
        }
        for (Event e : events) {
            this.processEvent(e);
        }
    }

    private void processEvent(final Event e) {
        switch (e.getType()) {
            case CACHE_ENTRY_CREATED: {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        SsoSessionCacheListener.this.cacheEntryCreated((CacheEntryCreatedEvent)e);
                    }
                });
                break;
            }
            case CACHE_ENTRY_MODIFIED: {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        SsoSessionCacheListener.this.cacheEntryModified((CacheEntryModifiedEvent)e);
                    }
                });
                break;
            }
            case CACHE_ENTRY_REMOVED: {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        SsoSessionCacheListener.this.cacheEntryRemoved((CacheEntryRemovedEvent)e);
                    }
                });
            }
        }
    }

    private void cacheEntryCreated(CacheEntryCreatedEvent event) {
        if (!(event.getKey() instanceof String)) {
            return;
        }
        String httpSessionId = (String)event.getKey();
        if (this.idMapper.hasSession(httpSessionId)) {
            LOG.tracev("IGNORING cacheEntryCreated {0}", (Object)httpSessionId);
            return;
        }
        String[] value = (String[])this.ssoCache.get((Object)httpSessionId);
        String ssoId = value[0];
        String principal = value[1];
        LOG.tracev("cacheEntryCreated {0}:{1}", (Object)httpSessionId, (Object)ssoId);
        this.idMapper.map(ssoId, principal, httpSessionId);
    }

    private void cacheEntryModified(CacheEntryModifiedEvent event) {
        if (!(event.getKey() instanceof String) || !(event.getValue() instanceof String[])) {
            return;
        }
        String httpSessionId = (String)event.getKey();
        String[] value = (String[])event.getValue();
        String ssoId = value[0];
        String principal = value[1];
        LOG.tracev("cacheEntryModified {0}:{1}", (Object)httpSessionId, (Object)ssoId);
        this.idMapper.removeSession(httpSessionId);
        this.idMapper.map(ssoId, principal, httpSessionId);
    }

    private void cacheEntryRemoved(CacheEntryRemovedEvent event) {
        if (!(event.getKey() instanceof String)) {
            return;
        }
        LOG.tracev("cacheEntryRemoved {0}", event.getKey());
        this.idMapper.removeSession((String)event.getKey());
    }
}

