/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jbossweb.infinispan;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.jbossweb.infinispan.SsoCacheSessionIdMapperUpdater;
import org.keycloak.adapters.saml.jbossweb.infinispan.SsoSessionCacheListener;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;

public class InfinispanSessionCacheIdMapperUpdater {
    private static final Logger LOG = Logger.getLogger(InfinispanSessionCacheIdMapperUpdater.class);
    public static final String DEFAULT_CACHE_CONTAINER_JNDI_NAME = "java:jboss/infinispan/container/web";
    private static final String DEPLOYMENT_CACHE_CONTAINER_JNDI_NAME_PARAM_NAME = "keycloak.sessionIdMapperUpdater.infinispan.cacheContainerJndi";
    private static final String DEPLOYMENT_CACHE_NAME_PARAM_NAME = "keycloak.sessionIdMapperUpdater.infinispan.deploymentCacheName";
    private static final String SSO_CACHE_NAME_PARAM_NAME = "keycloak.sessionIdMapperUpdater.infinispan.cacheName";

    public static SessionIdMapperUpdater addTokenStoreUpdaters(Context context, SessionIdMapper mapper, SessionIdMapperUpdater previousIdMapperUpdater) {
        boolean distributable = context.getDistributable();
        if (!distributable) {
            LOG.warnv("Deployment {0} does not use supported distributed session cache mechanism", (Object)context.getName());
            return previousIdMapperUpdater;
        }
        ServletContext servletContext = context.getServletContext();
        String cacheContainerLookup = servletContext != null && servletContext.getInitParameter(DEPLOYMENT_CACHE_CONTAINER_JNDI_NAME_PARAM_NAME) != null ? servletContext.getInitParameter(DEPLOYMENT_CACHE_CONTAINER_JNDI_NAME_PARAM_NAME) : DEFAULT_CACHE_CONTAINER_JNDI_NAME;
        String host = context.getParent() == null ? "" : context.getParent().getName();
        String contextPath = context.getPath();
        if ("/".equals(contextPath)) {
            contextPath = "/ROOT";
        }
        boolean deploymentSessionCacheNamePreset = servletContext != null && servletContext.getInitParameter(DEPLOYMENT_CACHE_NAME_PARAM_NAME) != null;
        String deploymentSessionCacheName = deploymentSessionCacheNamePreset ? servletContext.getInitParameter(DEPLOYMENT_CACHE_NAME_PARAM_NAME) : host + contextPath;
        boolean ssoCacheNamePreset = servletContext != null && servletContext.getInitParameter(SSO_CACHE_NAME_PARAM_NAME) != null;
        String ssoCacheName = ssoCacheNamePreset ? servletContext.getInitParameter(SSO_CACHE_NAME_PARAM_NAME) : deploymentSessionCacheName + ".ssoCache";
        try {
            EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)new InitialContext().lookup(cacheContainerLookup);
            Configuration ssoCacheConfiguration = cacheManager.getCacheConfiguration(ssoCacheName);
            if (ssoCacheConfiguration == null) {
                Configuration cacheConfiguration = cacheManager.getCacheConfiguration(deploymentSessionCacheName);
                if (cacheConfiguration == null) {
                    LOG.debugv("Using default cache container configuration for SSO cache. lookup={0}, looked up configuration of cache={1}", (Object)cacheContainerLookup, (Object)deploymentSessionCacheName);
                    ssoCacheConfiguration = cacheManager.getDefaultCacheConfiguration();
                } else {
                    LOG.debugv("Using distributed HTTP session cache configuration for SSO cache. lookup={0}, configuration taken from cache={1}", (Object)cacheContainerLookup, (Object)deploymentSessionCacheName);
                    ssoCacheConfiguration = cacheConfiguration;
                    cacheManager.defineConfiguration(ssoCacheName, ssoCacheConfiguration);
                }
            } else {
                LOG.debugv("Using custom configuration for SSO cache. lookup={0}, cache name={1}", (Object)cacheContainerLookup, (Object)ssoCacheName);
            }
            CacheMode ssoCacheMode = ssoCacheConfiguration.clustering().cacheMode();
            if (ssoCacheMode != CacheMode.REPL_ASYNC && ssoCacheMode != CacheMode.REPL_SYNC) {
                LOG.warnv("SSO cache mode is {0}, it is recommended to use replicated mode instead", (Object)ssoCacheConfiguration.clustering().cacheModeString());
            }
            Cache ssoCache = cacheManager.getCache(ssoCacheName, true);
            ssoCache.addListener((Object)new SsoSessionCacheListener(mapper));
            LOG.debugv("Added distributed SSO session cache, lookup={0}, cache name={1}", (Object)cacheContainerLookup, (Object)deploymentSessionCacheName);
            SsoCacheSessionIdMapperUpdater updater = new SsoCacheSessionIdMapperUpdater((Cache<String, String[]>)ssoCache, previousIdMapperUpdater);
            return updater;
        }
        catch (NamingException ex) {
            LOG.warnv("Failed to obtain distributed session cache container, lookup={0}", (Object)cacheContainerLookup);
            return previousIdMapperUpdater;
        }
    }
}

