/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.adapters.saml.config.IDP;
import org.keycloak.adapters.saml.config.parsers.AbstractKeycloakSamlAdapterV1Parser;
import org.keycloak.adapters.saml.config.parsers.KeycloakSamlAdapterV1QNames;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.util.HasQName;

public class HttpClientParser
extends AbstractKeycloakSamlAdapterV1Parser<IDP.HttpClientConfig> {
    private static final HttpClientParser INSTANCE = new HttpClientParser();

    private HttpClientParser() {
        super(KeycloakSamlAdapterV1QNames.HTTP_CLIENT);
    }

    public static HttpClientParser getInstance() {
        return INSTANCE;
    }

    protected IDP.HttpClientConfig instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        IDP.HttpClientConfig config = new IDP.HttpClientConfig();
        Boolean allowAnyHostname = StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_ALLOW_ANY_HOSTNAME);
        config.setAllowAnyHostname(allowAnyHostname == null ? false : allowAnyHostname);
        config.setClientKeystore(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_CLIENT_KEYSTORE));
        config.setClientKeystorePassword(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_CLIENT_KEYSTORE_PASSWORD));
        Integer connPoolSize = StaxParserUtil.getIntegerAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_CONNECTION_POOL_SIZE);
        config.setConnectionPoolSize(connPoolSize == null ? 0 : connPoolSize);
        Boolean disableTrustManager = StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_DISABLE_TRUST_MANAGER);
        config.setDisableTrustManager(disableTrustManager == null ? false : disableTrustManager);
        config.setProxyUrl(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_PROXY_URL));
        config.setTruststore(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_TRUSTSTORE));
        config.setTruststorePassword(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_TRUSTSTORE_PASSWORD));
        Long socketTimeout = StaxParserUtil.getLongAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_SOCKET_TIMEOUT);
        config.setSocketTimeout(socketTimeout == null ? -1L : socketTimeout);
        Long connectionTimeout = StaxParserUtil.getLongAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_CONNECTION_TIMEOUT);
        config.setConnectionTimeout(connectionTimeout == null ? -1L : connectionTimeout);
        Long connectionTTL = StaxParserUtil.getLongAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_CONNECTION_TTL);
        config.setConnectionTTL(connectionTTL == null ? -1L : connectionTTL);
        return config;
    }

    protected void processSubElement(XMLEventReader xmlEventReader, IDP.HttpClientConfig target, KeycloakSamlAdapterV1QNames element, StartElement elementDetail) throws ParsingException {
    }
}

