/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.proxy;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.proxy.SecurityInfo;
import org.keycloak.proxy.SecurityPathMatches;
import org.keycloak.proxy.SingleConstraintMatch;

public class ConstraintMatcherHandler
implements HttpHandler {
    protected static Logger log = Logger.getLogger(ConstraintMatcherHandler.class);
    public static final AttachmentKey<SingleConstraintMatch> CONSTRAINT_KEY = AttachmentKey.create(SingleConstraintMatch.class);
    protected SecurityPathMatches matcher;
    protected HttpHandler securedHandler;
    protected HttpHandler unsecuredHandler;
    protected String errorPage;

    public ConstraintMatcherHandler(SecurityPathMatches matcher, HttpHandler securedHandler, HttpHandler unsecuredHandler, String errorPage) {
        this.matcher = matcher;
        this.securedHandler = securedHandler;
        this.unsecuredHandler = unsecuredHandler;
        this.errorPage = errorPage;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        log.debugv("ConstraintMatcherHandler: {0}", (Object)exchange.getRelativePath());
        SingleConstraintMatch match = this.matcher.getSecurityInfo(exchange.getRelativePath(), exchange.getRequestMethod().toString());
        if (match == null || match.getRequiredRoles().isEmpty() && match.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.PERMIT) {
            this.unsecuredHandler.handleRequest(exchange);
            return;
        }
        if (match.getRequiredRoles().isEmpty() && match.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.DENY) {
            if (this.errorPage != null) {
                exchange.setRequestPath(this.errorPage);
                exchange.setRelativePath(this.errorPage);
                exchange.setResolvedPath(this.errorPage);
                this.unsecuredHandler.handleRequest(exchange);
            } else {
                exchange.setResponseCode(403);
                exchange.endExchange();
            }
            return;
        }
        if (match.getRequiredRoles().isEmpty() && match.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.PERMIT_AND_INJECT_IF_AUTHENTICATED) {
            boolean successfulAuthenticatedMethodFound = this.isSuccessfulAuthenticatedMethodFound(exchange);
            if (successfulAuthenticatedMethodFound) {
                exchange.putAttachment(CONSTRAINT_KEY, (Object)match);
                this.securedHandler.handleRequest(exchange);
                return;
            }
            this.unsecuredHandler.handleRequest(exchange);
            return;
        }
        log.debug((Object)"found constraint");
        exchange.getSecurityContext().setAuthenticationRequired();
        exchange.putAttachment(CONSTRAINT_KEY, (Object)match);
        this.securedHandler.handleRequest(exchange);
    }

    private boolean isSuccessfulAuthenticatedMethodFound(HttpServerExchange exchange) {
        boolean successfulAuthenticatedMethodFound = false;
        List authenticationMechanisms = exchange.getSecurityContext().getAuthenticationMechanisms();
        for (AuthenticationMechanism authenticationMechanism : authenticationMechanisms) {
            AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = authenticationMechanism.authenticate(exchange, exchange.getSecurityContext());
            if (!authenticationMechanismOutcome.equals((Object)AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED)) continue;
            successfulAuthenticatedMethodFound = true;
        }
        return successfulAuthenticatedMethodFound;
    }
}

