/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.adapters.authorization.util.KeycloakSecurityContextPlaceHolderResolver;
import org.keycloak.adapters.authorization.util.PlaceHolderResolver;
import org.keycloak.adapters.authorization.util.RequestPlaceHolderResolver;

public class PlaceHolders {
    private static Map<String, PlaceHolderResolver> resolvers = new HashMap<String, PlaceHolderResolver>();
    private static Pattern PLACEHOLDER_PATTERN;
    private static Pattern PLACEHOLDER_PARAM_PATTERN;

    public static List<String> resolve(String value, HttpRequest httpFacade) {
        Map<String, List<String>> placeHolders = PlaceHolders.parsePlaceHolders(value, httpFacade);
        if (!placeHolders.isEmpty()) {
            value = PlaceHolders.formatPlaceHolder(value);
            for (Map.Entry<String, List<String>> entry : placeHolders.entrySet()) {
                List<String> values = entry.getValue();
                if (values.isEmpty() || values.size() > 1) {
                    return values;
                }
                value = value.replaceAll(entry.getKey(), values.get(0)).trim();
            }
        }
        return Arrays.asList(value);
    }

    static String getParameter(String source, String messageIfNotFound) {
        Matcher matcher = PLACEHOLDER_PARAM_PATTERN.matcher(source);
        if (matcher.find()) {
            return matcher.group(1).replaceAll("'", "");
        }
        if (messageIfNotFound != null) {
            throw new RuntimeException(messageIfNotFound);
        }
        return null;
    }

    private static Map<String, List<String>> parsePlaceHolders(String value, HttpRequest httpFacade) {
        Map<String, List<String>> placeHolders = Collections.emptyMap();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(value);
        boolean found = matcher.find();
        if (found) {
            placeHolders = new HashMap<String, List<String>>();
            do {
                List<String> resolved;
                String placeHolder;
                int resolverNameIdx;
                if ((resolverNameIdx = (placeHolder = matcher.group(1)).indexOf(46)) == -1) {
                    throw new RuntimeException("Invalid placeholder [" + value + "]. Could not find resolver name.");
                }
                PlaceHolderResolver resolver = resolvers.get(placeHolder.substring(0, resolverNameIdx));
                if (resolver == null || (resolved = resolver.resolve(placeHolder, httpFacade)) == null) continue;
                placeHolders.put(PlaceHolders.formatPlaceHolder(placeHolder), resolved);
            } while (matcher.find());
        }
        return placeHolders;
    }

    private static String formatPlaceHolder(String placeHolder) {
        return placeHolder.replaceAll("\\{", "").replace("}", "").replace("[", "").replace("]", "").replace("[", "").replace("]", "");
    }

    static {
        resolvers.put(RequestPlaceHolderResolver.NAME, new RequestPlaceHolderResolver());
        resolvers.put("keycloak", new KeycloakSecurityContextPlaceHolderResolver());
        PLACEHOLDER_PATTERN = Pattern.compile("\\{(.+?)\\}");
        PLACEHOLDER_PARAM_PATTERN = Pattern.compile("\\[(.+?)\\]");
    }
}

