/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi.undertow;

import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.cxf.transport.http_undertow.CXFUndertowHttpHandler;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.undertow.UndertowAuthenticationMechanism;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class CxfKeycloakAuthHandler
implements CXFUndertowHttpHandler {
    private static final Logger LOG = Logger.getLogger(CxfKeycloakAuthHandler.class.getName());
    private static final IdentityManager IDENTITY_MANAGER = new IdentityManager(){

        public Account verify(Account account) {
            return account;
        }

        public Account verify(String id, Credential credential) {
            throw new IllegalStateException("Should never be called in Keycloak flow");
        }

        public Account verify(Credential credential) {
            throw new IllegalStateException("Should never be called in Keycloak flow");
        }
    };
    private final UndertowUserSessionManagement userSessionManagement = new UndertowUserSessionManagement();
    protected final NodesRegistrationManagement nodesRegistrationManagement = new NodesRegistrationManagement();
    protected final SessionIdMapper idMapper = new InMemorySessionIdMapper();
    private final AtomicReference<HttpHandler> securityHandler = new AtomicReference();
    private Pattern skipPattern;
    private int confidentialPort = 8443;
    private HttpHandler next;
    private KeycloakConfigResolver configResolver;
    private AdapterConfig adapterConfig;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.shouldSkip(exchange.getRequestPath())) {
            this.next.handleRequest(exchange);
        } else {
            this.getSecurityHandler().handleRequest(exchange);
        }
    }

    private HttpHandler getSecurityHandler() {
        if (this.securityHandler.get() == null) {
            HttpHandler handler = this.next;
            handler = new AuthenticationCallHandler(handler);
            handler = new AuthenticationConstraintHandler(handler);
            AdapterDeploymentContext deploymentContext = this.buildDeploymentContext();
            List<UndertowAuthenticationMechanism> mechanisms = Collections.singletonList(new UndertowAuthenticationMechanism(deploymentContext, this.userSessionManagement, this.nodesRegistrationManagement, this.confidentialPort, null));
            handler = new AuthenticationMechanismsHandler(handler, mechanisms);
            this.securityHandler.compareAndSet(null, (HttpHandler)new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, IDENTITY_MANAGER, "KEYCLOAK", handler));
        }
        return this.securityHandler.get();
    }

    private AdapterDeploymentContext buildDeploymentContext() {
        if (this.configResolver != null) {
            LOG.log(Level.INFO, "Using {0} to resolve Keycloak configuration on a per-request basis.", this.configResolver.getClass());
            return new AdapterDeploymentContext(this.configResolver);
        }
        if (this.adapterConfig != null) {
            KeycloakDeployment kd = KeycloakDeploymentBuilder.build((AdapterConfig)this.adapterConfig);
            return new AdapterDeploymentContext(kd);
        }
        LOG.warning("Adapter is unconfigured, Keycloak will deny every request");
        return new AdapterDeploymentContext();
    }

    public void setNext(HttpHandler nextHandler) {
        this.next = nextHandler;
    }

    private boolean shouldSkip(String requestPath) {
        return this.skipPattern != null && this.skipPattern.matcher(requestPath).matches();
    }

    public KeycloakConfigResolver getConfigResolver() {
        return this.configResolver;
    }

    public void setConfigResolver(KeycloakConfigResolver configResolver) {
        this.configResolver = configResolver;
    }

    public int getConfidentialPort() {
        return this.confidentialPort;
    }

    public void setConfidentialPort(int confidentialPort) {
        this.confidentialPort = confidentialPort;
    }

    public AdapterConfig getAdapterConfig() {
        return this.adapterConfig;
    }

    public void setAdapterConfig(AdapterConfig adapterConfig) {
        this.adapterConfig = adapterConfig;
    }

    public String getSkipPattern() {
        return this.skipPattern.pattern();
    }

    public void setSkipPattern(String skipPattern) {
        this.skipPattern = Pattern.compile(skipPattern, 32);
    }
}

