/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Servlet;
import org.jboss.logging.Logger;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServletReregistrationService {
    protected static final Logger log = Logger.getLogger(ServletReregistrationService.class);
    private static final List<String> FILTERED_PROPERTIES = Arrays.asList("objectClass", "service.id");
    private BundleContext bundleContext;
    private ServiceReference servletReference;
    private ServiceTracker webContainerTracker;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ServiceReference getServletReference() {
        return this.servletReference;
    }

    public void setServletReference(ServiceReference servletReference) {
        this.servletReference = servletReference;
    }

    protected ServiceTracker getWebContainerTracker() {
        return this.webContainerTracker;
    }

    public void start() {
        if (this.servletReference == null) {
            throw new IllegalStateException("No servlet reference provided");
        }
        final Servlet servlet = (Servlet)this.bundleContext.getService(this.servletReference);
        WebContainer externalWebContainer = this.findExternalWebContainer();
        if (externalWebContainer == null) {
            return;
        }
        try {
            externalWebContainer.unregisterServlet(servlet);
            log.debug((Object)("Original servlet with alias " + this.getAlias() + " unregistered successfully from external web container."));
        }
        catch (IllegalStateException e) {
            log.warn((Object)("Can't unregister servlet due to: " + e.getMessage()));
        }
        ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference webContainerServiceReference) {
                WebContainer ourWebContainer = (WebContainer)ServletReregistrationService.this.bundleContext.getService(webContainerServiceReference);
                ServletReregistrationService.this.registerServlet(ourWebContainer, servlet);
                log.debugv("Servlet with alias " + ServletReregistrationService.this.getAlias() + " registered to secured web container", new Object[0]);
                return ourWebContainer;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference webContainerServiceReference, Object service) {
                WebContainer ourWebContainer = (WebContainer)ServletReregistrationService.this.bundleContext.getService(webContainerServiceReference);
                String alias = ServletReregistrationService.this.getAlias();
                ourWebContainer.unregister(alias);
                log.debug((Object)("Servlet with alias " + ServletReregistrationService.this.getAlias() + " unregistered from secured web container"));
            }
        };
        this.webContainerTracker = new ServiceTracker(this.bundleContext, WebContainer.class.getName(), trackerCustomizer);
        this.webContainerTracker.open();
    }

    public void stop() {
        this.webContainerTracker.remove(this.webContainerTracker.getServiceReference());
        WebContainer externalWebContainer = this.findExternalWebContainer();
        Servlet servlet = (Servlet)this.bundleContext.getService(this.servletReference);
        this.registerServlet(externalWebContainer, servlet);
        log.debug((Object)("Servlet with alias " + this.getAlias() + " registered back to external web container"));
    }

    private String getAlias() {
        return (String)this.servletReference.getProperty("alias");
    }

    protected void registerServlet(WebContainer webContainer, Servlet servlet) {
        try {
            String[] propNames;
            Hashtable<String, Object> servletInitParams = new Hashtable<String, Object>();
            for (String propName : propNames = this.servletReference.getPropertyKeys()) {
                if (FILTERED_PROPERTIES.contains(propName)) continue;
                servletInitParams.put(propName, this.servletReference.getProperty(propName));
            }
            HttpContext httpContext = webContainer.createDefaultHttpContext();
            String alias = (String)this.servletReference.getProperty("alias");
            webContainer.registerServlet(alias, servlet, servletInitParams, httpContext);
        }
        catch (Exception e) {
            log.error((Object)"Can't register servlet in web container", (Throwable)e);
        }
    }

    protected WebContainer findExternalWebContainer() {
        BundleContext servletBundleContext = this.servletReference.getBundle().getBundleContext();
        ServiceReference webContainerReference = servletBundleContext.getServiceReference(WebContainer.class.getName());
        if (webContainerReference == null) {
            log.warn((Object)("Not found webContainer reference for bundle " + servletBundleContext));
            return null;
        }
        return (WebContainer)servletBundleContext.getService(webContainerReference);
    }
}

