/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.util.security.Constraint;
import org.jboss.logging.Logger;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PaxWebIntegrationService {
    protected static final Logger log = Logger.getLogger(PaxWebIntegrationService.class);
    private BundleContext bundleContext;
    private String jettyWebXmlLocation;
    private List<ConstraintMapping> constraintMappings;
    private ServiceTracker webContainerTracker;
    private HttpContext httpContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getJettyWebXmlLocation() {
        return this.jettyWebXmlLocation;
    }

    public void setJettyWebXmlLocation(String jettyWebXmlLocation) {
        this.jettyWebXmlLocation = jettyWebXmlLocation;
    }

    public List<ConstraintMapping> getConstraintMappings() {
        return this.constraintMappings;
    }

    public void setConstraintMappings(List<ConstraintMapping> constraintMappings) {
        this.constraintMappings = constraintMappings;
    }

    protected ServiceTracker getWebContainerTracker() {
        return this.webContainerTracker;
    }

    protected HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void start() {
        ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                return PaxWebIntegrationService.this.addingWebContainerCallback(reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                PaxWebIntegrationService.this.removingWebContainerCallback(reference);
            }
        };
        this.webContainerTracker = new ServiceTracker(this.bundleContext, WebContainer.class.getName(), trackerCustomizer);
        this.webContainerTracker.open();
    }

    public void stop() {
        this.webContainerTracker.remove(this.webContainerTracker.getServiceReference());
    }

    protected WebContainer addingWebContainerCallback(ServiceReference webContainerServiceReference) {
        WebContainer service = (WebContainer)this.bundleContext.getService(webContainerServiceReference);
        this.httpContext = service.createDefaultHttpContext();
        this.addJettyWebXml(service);
        if (this.constraintMappings == null) {
            throw new IllegalStateException("constraintMappings was null!");
        }
        for (ConstraintMapping constraintMapping : this.constraintMappings) {
            this.addConstraintMapping(service, constraintMapping);
        }
        service.registerLoginConfig("BASIC", "does-not-matter", null, null, this.httpContext);
        return service;
    }

    protected void addJettyWebXml(WebContainer service) {
        String jettyWebXmlLoc = this.jettyWebXmlLocation == null ? "/WEB-INF/jetty-web.xml" : this.jettyWebXmlLocation;
        URL jettyWebXml = this.bundleContext.getBundle().getResource(jettyWebXmlLoc);
        if (jettyWebXml != null) {
            log.debug((Object)("Found jetty-web XML configuration on bundle classpath on " + jettyWebXmlLoc));
            service.registerJettyWebXml(jettyWebXml, this.httpContext);
        } else {
            log.debug((Object)("Not found jetty-web XML configuration on bundle classpath on " + jettyWebXmlLoc));
        }
    }

    protected void addConstraintMapping(WebContainer service, ConstraintMapping constraintMapping) {
        String dataConstraintStr;
        Constraint constraint = constraintMapping.getConstraint();
        String[] roles = constraint.getRoles();
        String name = "Constraint-" + new Random().nextInt();
        int dataConstraint = constraint.getDataConstraint();
        switch (dataConstraint) {
            case -1: {
                dataConstraintStr = null;
                break;
            }
            case 0: {
                dataConstraintStr = "NONE";
                break;
            }
            case 2: {
                dataConstraintStr = "CONFIDENTIAL";
                break;
            }
            case 1: {
                dataConstraintStr = "INTEGRAL";
                break;
            }
            default: {
                log.warnv("Unknown data constraint: " + dataConstraint, new Object[0]);
                dataConstraintStr = "CONFIDENTIAL";
            }
        }
        List<String> rolesList = Arrays.asList(roles);
        log.debug((Object)("Adding security constraint name=" + name + ", url=" + constraintMapping.getPathSpec() + ", dataConstraint=" + dataConstraintStr + ", canAuthenticate=" + constraint.getAuthenticate() + ", roles=" + rolesList));
        service.registerConstraintMapping(name, constraintMapping.getPathSpec(), null, dataConstraintStr, constraint.getAuthenticate(), rolesList, this.httpContext);
    }

    protected void removingWebContainerCallback(ServiceReference serviceReference) {
        WebContainer service = (WebContainer)this.bundleContext.getService(serviceReference);
        if (service != null) {
            service.unregisterLoginConfig(this.httpContext);
            service.unregisterConstraintMapping(this.httpContext);
        }
    }
}

