/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mem;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.mem.ClientSessionAdapter;
import org.keycloak.models.sessions.mem.MemUserSessionProvider;
import org.keycloak.models.sessions.mem.entities.ClientSessionEntity;
import org.keycloak.models.sessions.mem.entities.UserSessionEntity;

public class UserSessionAdapter
implements UserSessionModel {
    private final KeycloakSession session;
    private MemUserSessionProvider provider;
    private final RealmModel realm;
    private final UserSessionEntity entity;

    public UserSessionAdapter(KeycloakSession session, MemUserSessionProvider provider, RealmModel realm, UserSessionEntity entity) {
        this.session = session;
        this.provider = provider;
        this.realm = realm;
        this.entity = entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public void setId(String id) {
        this.entity.setId(id);
    }

    public UserModel getUser() {
        return this.session.users().getUserById(this.entity.getUser(), this.realm);
    }

    public void setUser(UserModel user) {
        this.entity.setUser(user.getId());
    }

    public String getLoginUsername() {
        return this.entity.getLoginUsername();
    }

    public void setLoginUsername(String loginUsername) {
        this.entity.setLoginUsername(loginUsername);
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public void setIpAddress(String ipAddress) {
        this.entity.setIpAddress(ipAddress);
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public void setAuthMethod(String authMethod) {
        this.entity.setAuthMethod(authMethod);
    }

    public boolean isRememberMe() {
        return this.entity.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.entity.setRememberMe(rememberMe);
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public void setStarted(int started) {
        this.entity.setStarted(started);
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int lastSessionRefresh) {
        this.entity.setLastSessionRefresh(lastSessionRefresh);
    }

    public List<ClientSessionModel> getClientSessions() {
        LinkedList<ClientSessionModel> clientSessionModels = new LinkedList<ClientSessionModel>();
        if (this.entity.getClientSessions() != null) {
            for (ClientSessionEntity e : this.entity.getClientSessions()) {
                clientSessionModels.add(new ClientSessionAdapter(this.session, this.provider, this.realm, e));
            }
        }
        return clientSessionModels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

