/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.jpa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.models.sessions.jpa.entities.ClientSessionEntity;

@NamedQueries(value={@NamedQuery(name="removeClientUserSessionNoteByUser", query="delete from ClientUserSessionNoteEntity r where r.clientSession IN (select c from ClientSessionEntity c where c.session IN (select s from UserSessionEntity s where s.realmId = :realmId and s.userId = :userId))"), @NamedQuery(name="removeClientUserSessionNoteByClient", query="delete from ClientUserSessionNoteEntity r where r.clientSession IN (select c from ClientSessionEntity c where c.clientId = :clientId and c.realmId = :realmId)"), @NamedQuery(name="removeClientUserSessionNoteByRealm", query="delete from ClientUserSessionNoteEntity r where r.clientSession IN (select c from ClientSessionEntity c where c.realmId = :realmId)"), @NamedQuery(name="removeClientUserSessionNoteByExpired", query="delete from ClientUserSessionNoteEntity r where r.clientSession IN (select c from ClientSessionEntity c where c.session IN (select s from UserSessionEntity s where s.realmId = :realmId and (s.started < :maxTime or s.lastSessionRefresh < :idleTime)))"), @NamedQuery(name="removeDetachedUserClientSessionNoteByExpired", query="delete from ClientUserSessionNoteEntity r where r.clientSession IN (select c from ClientSessionEntity c where c.session IS NULL and c.realmId = :realmId and c.timestamp < :maxTime )")})
@Table(name="CLIENT_USER_SESSION_NOTE")
@Entity
@IdClass(value=Key.class)
public class ClientUserSessionNoteEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CLIENT_SESSION")
    protected ClientSessionEntity clientSession;
    @Id
    @Column(name="NAME")
    protected String name;
    @Column(name="VALUE")
    protected String value;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ClientSessionEntity getClientSession() {
        return this.clientSession;
    }

    public void setClientSession(ClientSessionEntity clientSession) {
        this.clientSession = clientSession;
    }

    public static class Key
    implements Serializable {
        protected ClientSessionEntity clientSession;
        protected String name;

        public Key() {
        }

        public Key(ClientSessionEntity clientSession, String name) {
            this.clientSession = clientSession;
            this.name = name;
        }

        public ClientSessionEntity getClientSession() {
            return this.clientSession;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.name != null ? !this.name.equals(key.name) : key.name != null) {
                return false;
            }
            return !(this.clientSession != null ? !this.clientSession.getId().equals(key.clientSession != null ? key.clientSession.getId() : null) : key.clientSession != null);
        }

        public int hashCode() {
            int result = this.clientSession != null ? this.clientSession.getId().hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

