/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.ClientInitialAccessEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ClientInitialAccessAdapter
implements ClientInitialAccessModel {
    private final KeycloakSession session;
    private final InfinispanUserSessionProvider provider;
    private final Cache<String, SessionEntity> cache;
    private final RealmModel realm;
    private final ClientInitialAccessEntity entity;

    public ClientInitialAccessAdapter(KeycloakSession session, InfinispanUserSessionProvider provider, Cache<String, SessionEntity> cache, RealmModel realm, ClientInitialAccessEntity entity) {
        this.session = session;
        this.provider = provider;
        this.cache = cache;
        this.realm = realm;
        this.entity = entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public int getExpiration() {
        return this.entity.getExpiration();
    }

    public int getCount() {
        return this.entity.getCount();
    }

    public int getRemainingCount() {
        return this.entity.getRemainingCount();
    }

    public void decreaseRemainingCount() {
        this.entity.setRemainingCount(this.entity.getRemainingCount() - 1);
        this.update();
    }

    void update() {
        this.provider.getTx().replace(this.cache, this.entity.getId(), this.entity);
    }
}

