/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.entities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.authorization.model.Scope;
import org.keycloak.connections.mongo.api.MongoCollection;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.entities.AbstractIdentifiableEntity;

@MongoCollection(collectionName="resources")
public class ResourceEntity
extends AbstractIdentifiableEntity
implements MongoIdentifiableEntity {
    private String name;
    private String uri;
    private String type;
    private String iconUri;
    private String owner;
    private String resourceServerId;
    private List<String> scopes = new ArrayList<String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public void setResourceServerId(String resourceServerId) {
        this.resourceServerId = resourceServerId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void updateScopes(Set<Scope> toUpdate) {
        boolean hasScope;
        for (Scope scope : toUpdate) {
            hasScope = false;
            for (String existingScope : this.scopes) {
                if (!existingScope.equals(scope.getId())) continue;
                hasScope = true;
            }
            if (hasScope) continue;
            this.scopes.add(scope.getId());
        }
        for (String scopeId : new HashSet<String>(this.scopes)) {
            hasScope = false;
            for (Scope scope : toUpdate) {
                if (!scopeId.equals(scope.getId())) continue;
                hasScope = true;
            }
            if (hasScope) continue;
            this.scopes.remove(scopeId);
        }
    }

    @Override
    public void afterRemove(MongoStoreInvocationContext invocationContext) {
    }
}

