/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.store;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.mongo.store.MongoPolicyStore;
import org.keycloak.authorization.mongo.store.MongoResourceServerStore;
import org.keycloak.authorization.mongo.store.MongoResourceStore;
import org.keycloak.authorization.mongo.store.MongoScopeStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.KeycloakSession;

public class MongoStoreFactory
implements StoreFactory {
    private final MongoStoreInvocationContext invocationContext;
    private final KeycloakSession session;

    public MongoStoreFactory(MongoStoreInvocationContext invocationContext, KeycloakSession session) {
        this.invocationContext = invocationContext;
        this.session = session;
    }

    public PolicyStore getPolicyStore() {
        return new MongoPolicyStore(this.invocationContext, this.getAuthorizationProvider());
    }

    public ResourceServerStore getResourceServerStore() {
        return new MongoResourceServerStore(this.invocationContext, this.getAuthorizationProvider());
    }

    public ResourceStore getResourceStore() {
        return new MongoResourceStore(this.invocationContext, this.getAuthorizationProvider());
    }

    public ScopeStore getScopeStore() {
        return new MongoScopeStore(this.invocationContext, this.getAuthorizationProvider());
    }

    private AuthorizationProvider getAuthorizationProvider() {
        return (AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class);
    }

    public void close() {
    }
}

